/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework;

import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.UndoableModelAspectEdit;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.util.ChangeEventSupport;

public abstract class ViewAspectAdapter {
    private Object oldModelAspectValue;
    private final ModelAspectId modelAspectId;
    private EditRule editRule;
    private ViewValueConverter viewValueConverter;
    private ModelEditMediator modelEditMediator;
    private ChangeEventSupport changeEventSupport;
    private UndoableEditSupport undoableEditSupport;
    private ChangeEvent changeEvent = new ChangeEvent(this);

    protected ViewAspectAdapter(ModelAspectId modelAspectId) {
        this(modelAspectId, null, null, null);
    }

    protected ViewAspectAdapter(ModelAspectId modelAspectId, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
        this.modelAspectId = modelAspectId;
        this.changeEventSupport = new ChangeEventSupport(this);
        this.setEditRule(editRule);
        this.setViewValueConverter(viewValueConverter);
        this.setModelEditMediator(modelEditMediator);
    }

    public abstract boolean isEditable();

    public abstract void setEditable(boolean var1);

    public abstract Component getViewComponent();

    public abstract Object getViewAspectValue();

    public abstract String getViewAspectStringValue();

    protected abstract void setViewAspectValue(Object var1) throws IllegalArgumentException;

    protected abstract void setViewAspectStringValue(String var1) throws IllegalArgumentException;

    public Object getModelAspectValue() throws ViewValueConversionException {
        Object viewAspectValue = null;
        try {
            viewAspectValue = this.getViewAspectValue();
        }
        catch (Exception e) {
            throw new ViewValueConversionException(e, this.getModelAspectId());
        }
        ViewValueConverter converter = this.getViewValueConverter();
        if (converter != null) {
            if (converter.isViewValueToModelSupported()) {
                try {
                    viewAspectValue = converter.viewValueToModel(viewAspectValue);
                }
                catch (ViewValueConversionException e) {
                    e.setModelAspectId(this.getModelAspectId());
                    throw e;
                }
            } else {
                throw new ViewValueConversionException("View value to Model value conversion not supported", this.getModelAspectId());
            }
        }
        return viewAspectValue;
    }

    public void setModelAspectValue(Object modelAspectValue) throws ViewValueConversionException {
        this.oldModelAspectValue = modelAspectValue;
        ViewValueConverter converter = this.getViewValueConverter();
        try {
            if (converter == null) {
                this.setViewAspectValue(modelAspectValue);
            } else if (converter.getViewClass() == String.class) {
                String viewAspectValue = modelAspectValue == null ? "" : (String)converter.modelValueToView(modelAspectValue);
                this.setViewAspectStringValue(viewAspectValue);
            } else {
                Object viewAspectValue = converter.modelValueToView(modelAspectValue);
                this.setViewAspectValue(viewAspectValue);
            }
        }
        catch (ViewValueConversionException e) {
            e.setModelAspectId(this.getModelAspectId());
            throw e;
        }
    }

    public ModelAspectId getModelAspectId() {
        return this.modelAspectId;
    }

    public EditRule getEditRule() {
        return this.editRule;
    }

    public final void setEditRule(EditRule editRule) {
        this.editRule = editRule;
    }

    public ViewValueConverter getViewValueConverter() {
        return this.viewValueConverter;
    }

    public final void setViewValueConverter(ViewValueConverter viewValueConverter) {
        this.viewValueConverter = viewValueConverter;
    }

    public ModelEditMediator getModelEditMediator() {
        return this.modelEditMediator;
    }

    public final void setModelEditMediator(ModelEditMediator modelEditMediator) {
        if (this.modelEditMediator != null) {
            this.modelEditMediator.removeViewAspectAdapter(this);
        }
        this.modelEditMediator = modelEditMediator;
        if (this.modelEditMediator != null) {
            this.modelEditMediator.addViewAspectAdapter(this);
        }
    }

    public UndoableModelAspectEdit makeUndoableModelAspectEdit(ModelObjectAdapter modelObjectAdapter) throws ViewValueConversionException {
        Object newModelAspectValue = this.getModelAspectValue();
        if (newModelAspectValue == this.oldModelAspectValue) {
            return null;
        }
        return new UndoableModelAspectEdit("changed " + this.modelAspectId, modelObjectAdapter, this.modelAspectId, this.oldModelAspectValue, newModelAspectValue);
    }

    protected Object getOldModelAspectValue() {
        return this.oldModelAspectValue;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport.removeChangeListener(listener);
    }

    protected void fireChangeEvent() {
        this.changeEventSupport.fireChangeEvent(this.changeEvent);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        if (this.undoableEditSupport == null) {
            this.undoableEditSupport = new UndoableEditSupport(this);
        }
        this.undoableEditSupport.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        if (this.undoableEditSupport != null) {
            this.undoableEditSupport.removeUndoableEditListener(listener);
        }
    }

    protected void fireUndoableEditEvent(UndoableEdit anEdit) {
        if (this.undoableEditSupport != null) {
            this.undoableEditSupport.postEdit(anEdit);
        }
    }
}

