/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.model;

import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.util.WrapperRuntimeException;

public class JavaBeanPropertyAdapter
extends ModelAspectAdapter {
    private Method getterMethod;
    private Method setterMethod;

    public JavaBeanPropertyAdapter(PropertyDescriptor propDesc) {
        super(ModelAspectId.forName(propDesc.getName()), propDesc.getPropertyType());
        this.getterMethod = propDesc.getReadMethod();
        this.setterMethod = propDesc.getWriteMethod();
    }

    @Override
    public boolean isReadonlyAspect() {
        return this.setterMethod == null;
    }

    @Override
    protected Object getAspectValue(Object modelObject, ModelObjectAdapter modelObjectAdapter) {
        try {
            return this.getterMethod.invoke(modelObject, new Object[0]);
        }
        catch (IllegalAccessException illegalX) {
            throw new WrapperRuntimeException(illegalX);
        }
        catch (InvocationTargetException callX) {
            throw new WrapperRuntimeException(callX.getTargetException());
        }
    }

    @Override
    protected void setAspectValue(Object modelObject, Object newAspectValue, ModelObjectAdapter modelObjectAdapter) throws PropertyVetoException, IllegalArgumentException, UnsupportedOperationException {
        if (this.setterMethod == null) {
            throw new UnsupportedOperationException("setAspectValue: " + this.getModelAspectId());
        }
        try {
            this.setterMethod.invoke(modelObject, newAspectValue);
        }
        catch (IllegalAccessException illegalX) {
            throw new WrapperRuntimeException(illegalX);
        }
        catch (InvocationTargetException callX) {
            Throwable targetException = callX.getTargetException();
            if (targetException instanceof PropertyVetoException) {
                throw (PropertyVetoException)targetException;
            }
            throw new WrapperRuntimeException(targetException);
        }
    }
}

