/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import modelobjects.framework.model.ImmutableModelObjectAdapter;
import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.model.NoSuchAspectException;

public class ModelDescriptor {
    private final Class modelType;
    private final Object editTypeKey;
    private final Vector aspectAdapterList;
    private final Hashtable aspectAdapterTable;
    private final ArrayList modelObjectValidators = new ArrayList();
    private ModelObjectPropagator modelObjectPropagator = null;
    private static final Hashtable descriptorRegistry = new Hashtable();

    public ModelDescriptor(Class modelType) {
        this(modelType, modelType);
    }

    public ModelDescriptor(Class modelType, Object editTypeKey) {
        if (modelType == null) {
            throw new IllegalArgumentException("ModelDescriptor.modelType = null");
        }
        if (editTypeKey == null) {
            throw new IllegalArgumentException("ModelDescriptor.editTypeKey = null");
        }
        this.modelType = modelType;
        this.editTypeKey = editTypeKey;
        this.aspectAdapterList = new Vector();
        this.aspectAdapterTable = new Hashtable();
        descriptorRegistry.put(editTypeKey, this);
    }

    public static ModelDescriptor forClass(Class modelType) {
        return (ModelDescriptor)descriptorRegistry.get(modelType);
    }

    public static ModelDescriptor forEditTypeKey(Object editTypeKey) {
        return (ModelDescriptor)descriptorRegistry.get(editTypeKey);
    }

    public static void unregisterByType(Object editTypeKey) {
        descriptorRegistry.remove(editTypeKey);
    }

    public static void unregister(ModelDescriptor modelDesc) {
        descriptorRegistry.remove(modelDesc.getModelType());
    }

    public final synchronized void addModelAspectAdapter(ModelAspectAdapter modelAspectAdapter) {
        ModelAspectId aspectId = modelAspectAdapter.getModelAspectId();
        ModelAspectAdapter previousAspectAdapter = (ModelAspectAdapter)this.aspectAdapterTable.get(aspectId);
        if (previousAspectAdapter != null) {
            int pos = this.aspectAdapterList.indexOf(this.aspectAdapterTable.get(aspectId));
            this.aspectAdapterList.setElementAt(modelAspectAdapter, pos);
        } else {
            this.aspectAdapterList.addElement(modelAspectAdapter);
        }
        this.aspectAdapterTable.put(aspectId, modelAspectAdapter);
    }

    public ModelObjectAdapter makeModelObjectAdapter(Object modelObject) {
        return new ModelObjectAdapter(modelObject, this);
    }

    public ImmutableModelObjectAdapter makeModelObjectAdapter() {
        return new ImmutableModelObjectAdapter(this);
    }

    public Class getModelType() {
        return this.modelType;
    }

    public Object getEditTypeKey() {
        return this.editTypeKey;
    }

    protected ModelAspectAdapter getModelAspectAdapter(ModelAspectId aspectId) throws NoSuchAspectException {
        ModelAspectAdapter result = (ModelAspectAdapter)this.aspectAdapterTable.get(aspectId);
        if (result == null) {
            throw new NoSuchAspectException(aspectId.getName());
        }
        return result;
    }

    public boolean isDefaultValue(ModelAspectId aspectId, Object value) throws NoSuchAspectException {
        return this.getModelAspectAdapter(aspectId).isDefaultValue(value);
    }

    public synchronized ModelAspectAdapter[] getModelAspectAdapters() {
        Object[] result = new ModelAspectAdapter[this.aspectAdapterList.size()];
        this.aspectAdapterList.copyInto(result);
        return result;
    }

    protected Set getAspectIds() {
        return this.aspectAdapterTable.keySet();
    }

    public void addModelObjectValidator(ModelObjectValidator validator) {
        this.modelObjectValidators.add(validator);
    }

    public void removeModelObjectValidator(ModelObjectValidator validator) {
        this.modelObjectValidators.remove(validator);
    }

    public Iterator getModelObjectValidators() {
        return this.modelObjectValidators.iterator();
    }

    public ModelObjectPropagator getModelObjectPropagator() {
        return this.modelObjectPropagator;
    }

    public void setModelObjectPropagator(ModelObjectPropagator propagator) {
        this.modelObjectPropagator = propagator;
    }

    public void validateModelEdit(ModelObjectAdapter adapter) throws ModelValidationException {
        Iterator i = this.modelObjectValidators.iterator();
        while (i.hasNext()) {
            ((ModelObjectValidator)i.next()).validateModelEdit(adapter);
        }
    }

    public void validateModelCreation(ModelObjectAdapter adapter) throws ModelValidationException {
        Iterator i = this.modelObjectValidators.iterator();
        while (i.hasNext()) {
            ((ModelObjectValidator)i.next()).validateModelCreation(adapter);
        }
    }

    public void validateModelDeletion(ModelObjectAdapter adapter) throws ModelValidationException {
        Iterator i = this.modelObjectValidators.iterator();
        while (i.hasNext()) {
            ((ModelObjectValidator)i.next()).validateModelDeletion(adapter);
        }
    }

    public void propagateModelEdit(ModelObjectAdapter adapter) throws ModelPropagationException {
        if (this.modelObjectPropagator != null) {
            this.modelObjectPropagator.propagateModelEdit(adapter);
        }
    }

    public void propagateModelCreation(ModelObjectAdapter adapter) throws ModelPropagationException {
        if (this.modelObjectPropagator != null) {
            this.modelObjectPropagator.propagateModelCreation(adapter);
        }
    }

    public void propagateModelDeletion(ModelObjectAdapter adapter) throws ModelPropagationException {
        if (this.modelObjectPropagator != null) {
            this.modelObjectPropagator.propagateModelDeletion(adapter);
        }
    }
}

