/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.model;

import java.beans.PropertyVetoException;
import java.util.Hashtable;
import modelobjects.framework.model.ImmutableModelObjectAdapter;
import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.model.NoSuchAspectException;

public class ModelObjectAdapter {
    protected Object modelObject;
    protected ModelDescriptor modelDescriptor;
    protected Hashtable annotationValues;

    public ModelObjectAdapter(Object modelObject, ModelDescriptor modelDescriptor) {
        if (!modelDescriptor.getModelType().isInstance(modelObject)) {
            throw new IllegalArgumentException("model is not an instance of " + modelDescriptor.getModelType() + " - it is a " + modelObject.getClass().getName());
        }
        this.modelObject = modelObject;
        this.modelDescriptor = modelDescriptor;
    }

    ModelObjectAdapter(ModelDescriptor modelDescriptor) {
        if (!(this instanceof ImmutableModelObjectAdapter)) {
            throw new UnsupportedOperationException("allowed only for ImmutableModelObjectAdapters");
        }
        this.modelObject = null;
        this.modelDescriptor = modelDescriptor;
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public ModelDescriptor getModelDescriptor() {
        return this.modelDescriptor;
    }

    public boolean isReadonlyAspect(ModelAspectId aspectId) throws NoSuchAspectException {
        ModelAspectAdapter modelAspectAdapter = this.modelDescriptor.getModelAspectAdapter(aspectId);
        return modelAspectAdapter.isReadonlyAspect();
    }

    public synchronized Object getAspectValue(ModelAspectId aspectId) throws NoSuchAspectException {
        ModelAspectAdapter modelAspectAdapter = this.modelDescriptor.getModelAspectAdapter(aspectId);
        return modelAspectAdapter.getAspectValue(this.modelObject, this);
    }

    public synchronized void setAspectValue(ModelAspectId aspectId, Object newAspectValue) throws PropertyVetoException, NoSuchAspectException {
        ModelAspectAdapter modelAspectAdapter = this.modelDescriptor.getModelAspectAdapter(aspectId);
        modelAspectAdapter.setAspectValue(this.modelObject, newAspectValue, this);
    }

    public void validateModel() throws ModelValidationException {
        this.modelDescriptor.validateModelEdit(this);
    }

    public void validateNewModel() throws ModelValidationException {
        this.modelDescriptor.validateModelCreation(this);
    }

    public void validateModelDeletion() throws ModelValidationException {
        this.modelDescriptor.validateModelDeletion(this);
    }

    public void propagateModelEdit() throws ModelPropagationException {
        this.modelDescriptor.propagateModelEdit(this);
    }

    public void propagateModelCreation() throws ModelPropagationException {
        this.modelDescriptor.propagateModelCreation(this);
    }

    public void propagateModelDeletion() throws ModelPropagationException {
        this.modelDescriptor.propagateModelDeletion(this);
    }

    public Object getAnnotationAspectValue(ModelAspectId aspectId) {
        if (this.annotationValues == null) {
            return null;
        }
        return this.annotationValues.get(aspectId);
    }

    public boolean hasAnnotationAspectValue(ModelAspectId aspectId) {
        if (this.annotationValues == null) {
            return false;
        }
        return this.annotationValues.containsKey(aspectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAnnotationAspectValue(ModelAspectId aspectId, Object value) {
        if (this.annotationValues == null) {
            if (value == null) {
                return null;
            }
            ModelObjectAdapter modelObjectAdapter = this;
            synchronized (modelObjectAdapter) {
                if (this.annotationValues == null) {
                    this.annotationValues = new Hashtable();
                }
            }
        }
        if (value == null) {
            return this.annotationValues.remove(aspectId);
        }
        return this.annotationValues.put(aspectId, value);
    }
}

