/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class ButtonGroupAdapter
extends ViewAspectAdapter
implements ItemListener {
    private ButtonGroup buttonGroup;
    private boolean editable;

    public ButtonGroupAdapter(ModelAspectId modelAspectId, ButtonGroup buttonGroup) {
        super(modelAspectId);
        this.setButtonGroup(buttonGroup);
        this.editable = true;
    }

    public ButtonGroupAdapter(ModelAspectId modelAspectId, ButtonGroup buttonGroup, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
        this.setButtonGroup(buttonGroup);
        this.editable = true;
    }

    protected final void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.addItemListener(this);
        }
    }

    @Override
    public Component getViewComponent() {
        return null;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable != this.editable) {
            Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                button.setEnabled(editable);
            }
            this.editable = editable;
        }
    }

    @Override
    public Object getViewAspectValue() {
        return this.getViewAspectStringValue();
    }

    @Override
    public String getViewAspectStringValue() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        return buttonModel == null ? null : buttonModel.getActionCommand();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        this.setViewAspectStringValue((String)viewAspectValue);
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        Object selectedButton = null;
        while (buttons.hasMoreElements()) {
            AbstractButton button;
            String cmd = (button = buttons.nextElement()).getActionCommand();
            button.setSelected(cmd != null && cmd.equals(viewStringValue));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireChangeEvent();
    }
}

