/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class DesktopPane
extends JDesktopPane
implements ComponentListener,
ContainerListener,
Scrollable {
    private static final int CASCADE = 1;
    private static final int TILE = 2;
    private static final int DEFAULT_OFFSETX = 24;
    private static final int DEFAULT_OFFSETY = 24;
    private static final int UNUSED_HEIGHT = 48;
    private static final int NON_WINDOW_ITEM_COUNT = 3;
    private JScrollPane scrollpane;
    private int nextX;
    private int nextY;
    private int offsetX = 24;
    private int offsetY = 24;
    private int currentLayoutSetting = 0;
    private boolean recomputeSizeInhibited;
    private ArrayList internalFrames;
    private JMenu internalFramesMenu;
    private InternalFramesWatcher internalFramesWatcher;

    public DesktopPane() {
        this.addContainerListener();
        this.internalFrames = new ArrayList();
        this.internalFramesMenu = new JMenu("Window");
        JMenuItem tileItem = new JMenuItem(new TileAction());
        JMenuItem cascadeItem = new JMenuItem(new CascadeAction());
        this.internalFramesMenu.addSeparator();
        this.internalFramesMenu.add(tileItem);
        this.internalFramesMenu.add(cascadeItem);
        this.internalFramesWatcher = new InternalFramesWatcher();
        this.setDoubleBuffered();
    }

    private void addContainerListener() {
        this.addContainerListener(this);
    }

    private void setDoubleBuffered() {
        this.setDoubleBuffered(true);
    }

    public JMenu getInternalFramesMenu() {
        return this.internalFramesMenu;
    }

    public void addCascaded(Component comp) {
        super.add(comp);
        if (comp instanceof JInternalFrame) {
            this.cascade(comp);
        }
        this.moveToFront(comp);
    }

    public void cascadeAll() {
        Component[] comps = this.getComponents();
        int count = comps.length;
        this.nextX = 0;
        this.nextY = 0;
        for (int i = count - 1; i >= 0; --i) {
            Component comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
            this.cascade(comp);
        }
        this.setCurrentLayoutSetting(1);
    }

    public void tileAll() {
        Component comp;
        DesktopManager manager = this.getDesktopManager();
        if (manager == null) {
            return;
        }
        Component[] comps = this.getComponents();
        int count = 0;
        for (int i = 0; i < comps.length; ++i) {
            comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
            ++count;
        }
        if (count != 0) {
            double root = Math.sqrt(count);
            int rows = (int)root;
            int columns = count / rows;
            int spares = count - columns * rows;
            Dimension paneSize = this.getSize();
            int columnWidth = paneSize.width / columns;
            int availableHeight = paneSize.height - 48;
            int mainHeight = availableHeight / rows;
            int smallerHeight = availableHeight / (rows + 1);
            int rowHeight = mainHeight;
            int x = 0;
            int y = 0;
            int thisRow = rows;
            int normalColumns = columns - spares;
            for (int i = comps.length - 1; i >= 0; --i) {
                comp = comps[i];
                if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
                manager.setBoundsForFrame((JComponent)comp, x, y, columnWidth, rowHeight);
                y += rowHeight;
                if (--thisRow != 0) continue;
                y = 0;
                x += columnWidth;
                if (--normalColumns <= 0) {
                    thisRow = rows + 1;
                    rowHeight = smallerHeight;
                    continue;
                }
                thisRow = rows;
            }
        }
        this.setCurrentLayoutSetting(2);
    }

    public void setCascadeOffsets(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setCascadeOffsets(Point pt) {
        this.offsetX = pt.x;
        this.offsetY = pt.y;
    }

    public Point getCascadeOffsets() {
        return new Point(this.offsetX, this.offsetY);
    }

    protected void cascade(Component comp) {
        Dimension paneSize = this.getSize();
        int targetWidth = 3 * paneSize.width / 4;
        int targetHeight = 3 * paneSize.height / 4;
        DesktopManager manager = this.getDesktopManager();
        if (manager == null) {
            comp.setBounds(0, 0, targetWidth, targetHeight);
            return;
        }
        if (this.nextX + targetWidth > paneSize.width || this.nextY + targetHeight > paneSize.height) {
            this.nextX = 0;
            this.nextY = 0;
        }
        manager.setBoundsForFrame((JComponent)comp, this.nextX, this.nextY, targetWidth, targetHeight);
        this.nextX += this.offsetX;
        this.nextY += this.offsetY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recomputeSize() {
        if (this.recomputeSizeInhibited) {
            return;
        }
        try {
            this.recomputeSizeInhibited = true;
            Dimension viewportSize = this.scrollpane == null ? new Dimension(0, 0) : this.scrollpane.getViewport().getSize();
            int width = viewportSize.width;
            int height = viewportSize.height;
            for (Component comp : this.getComponents()) {
                if (!comp.isVisible()) continue;
                Rectangle r = comp.getBounds();
                width = Math.max(width, r.x + r.width);
                height = Math.max(height, r.y + r.height);
            }
            Dimension size = this.getSize();
            if (width != size.width || height != size.height) {
                Dimension newSize = new Dimension(width, height);
                this.setSize(newSize);
                this.setPreferredSize(newSize);
            }
            if (this.scrollpane != null) {
                this.scrollpane.invalidate();
                this.scrollpane.validate();
            }
        }
        finally {
            this.recomputeSizeInhibited = false;
        }
    }

    @Override
    public void componentAdded(ContainerEvent event) {
        Component comp = event.getChild();
        comp.addComponentListener(this);
        if (comp instanceof JInternalFrame && !this.internalFrames.contains(comp)) {
            JInternalFrame iframe = (JInternalFrame)comp;
            this.internalFrames.add(iframe);
            this.internalFramesMenu.insert(new OpenInternalFrameAction(iframe), this.internalFramesMenu.getItemCount() - 3);
            DesktopPane.assignMnemonics(this.internalFramesMenu, null);
            iframe.addInternalFrameListener(this.internalFramesWatcher);
        }
        this.recomputeSize();
    }

    @Override
    public void componentRemoved(ContainerEvent event) {
        Component comp = event.getChild();
        comp.removeComponentListener(this);
        this.recomputeSize();
    }

    @Override
    public void componentMoved(ComponentEvent event) {
        this.recomputeSize();
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.recomputeSize();
    }

    @Override
    public void componentShown(ComponentEvent event) {
        this.recomputeSize();
    }

    @Override
    public void componentHidden(ComponentEvent event) {
        this.recomputeSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(700, 500);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        boolean vertical = orientation == 1;
        return vertical ? 25 : 40;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int fullSize = orientation == 1 ? visibleRect.height : visibleRect.width;
        return Math.max(10, (int)((double)fullSize * 0.9));
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (x != this.getX() || y != this.getY() || w != this.getWidth() || h != this.getHeight()) {
            super.setBounds(x, y, w, h);
            this.recomputeSize();
        }
    }

    private void refreshSettings() {
        if (this.getCurrentLayoutSetting() == 1) {
            this.cascadeAll();
        } else if (this.getCurrentLayoutSetting() == 2) {
            this.tileAll();
        }
    }

    private void setCurrentLayoutSetting(int setting) {
        this.currentLayoutSetting = setting;
    }

    private int getCurrentLayoutSetting() {
        return this.currentLayoutSetting;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JScrollPane scrollpane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (scrollpane != null && this.getParent().getParent() == scrollpane) {
            this.scrollpane = scrollpane;
            scrollpane.getViewport().addComponentListener(this);
        }
    }

    void removeMenuItemFor(JInternalFrame internalFrame) {
        JMenu menu = this.internalFramesMenu;
        String name = internalFrame.getTitle();
        int itemCount = menu.getItemCount() - 3;
        for (int i = 0; i < itemCount; ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (!name.equals(menuItem.getText())) continue;
            menu.remove(menuItem);
            break;
        }
    }

    public static void assignMnemonics(JMenuBar menubar) {
        String usedChars = "";
        int count = menubar.getMenuCount();
        for (int i = 0; i < count; ++i) {
            JMenu menu = menubar.getMenu(i);
            usedChars = DesktopPane.assignMnemonics(menu, usedChars);
        }
    }

    public static String assignMnemonics(JMenuItem menuItem, String usedChars) {
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            String menuUsedChars = "";
            int itemCount = menu.getItemCount() - 3;
            for (int i = 0; i < itemCount; ++i) {
                JMenuItem item = menu.getItem(i);
                if (item == menuItem) continue;
                menuUsedChars = DesktopPane.assignMnemonics(item, menuUsedChars);
            }
        }
        if (usedChars != null) {
            String label = menuItem.getText();
            int numChars = label == null ? 0 : label.length();
            for (int i = 0; i < numChars; ++i) {
                char c = label.charAt(i);
                char upper = Character.toUpperCase(c);
                int pos = usedChars.indexOf(upper);
                if (pos != -1) continue;
                menuItem.setMnemonic(c);
                return usedChars + upper;
            }
        }
        return usedChars;
    }

    public static void main(String[] args) {
        JFrame window = new JFrame("DesktopPane Test");
        window.setDefaultCloseOperation(3);
        window.setBounds(300, 300, 700, 400);
        DesktopPane desktopPane = new DesktopPane();
        desktopPane.setSize(800, 600);
        JScrollPane desktopScroller = new JScrollPane(desktopPane);
        window.getContentPane().add((Component)desktopScroller, "Center");
        JMenuBar menubar = new JMenuBar();
        JMenu windowsMenu = desktopPane.internalFramesMenu;
        windowsMenu.setMnemonic('w');
        menubar.add(windowsMenu);
        window.setJMenuBar(menubar);
        window.validate();
        window.setVisible(true);
        JInternalFrame f1 = new JInternalFrame("Fred", true, true, true, true);
        f1.setBounds(100, 100, 200, 200);
        desktopPane.add(f1);
        f1.setVisible(true);
        JInternalFrame f2 = new JInternalFrame("Barney", true, true, true, true);
        f2.setBounds(300, 300, 200, 200);
        desktopPane.add(f2);
        f2.setVisible(true);
    }

    class CascadeAction
    extends AbstractAction {
        public CascadeAction() {
            this.putProperties();
        }

        private void putProperties() {
            this.putValue("Name", "Cascade");
            this.putValue("ShortDescription", "Cascade windows");
            this.putValue("LongDescription", "Cascade windows");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("ActionCommandKey", "cascade-command");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DesktopPane.this.cascadeAll();
        }
    }

    class TileAction
    extends AbstractAction {
        public TileAction() {
            this.putProperties();
        }

        private void putProperties() {
            this.putValue("Name", "Tile");
            this.putValue("ShortDescription", "Tile Windows");
            this.putValue("LongDescription", "Tile Windows");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("ActionCommandKey", "tile-command");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DesktopPane.this.tileAll();
        }
    }

    static class ImprovedDesktopMgr
    extends DefaultDesktopManager {
        private transient JComponent modComp = null;
        private transient Rectangle modRect = null;
        private transient JDesktopPane desktop;
        private transient Graphics graphics = null;

        @Override
        public void beginDraggingFrame(JComponent f) {
            this.startMods(f);
            this.drawModBounds();
        }

        @Override
        public void dragFrame(JComponent f, int newX, int newY) {
            if (this.modComp == f) {
                this.drawModBounds();
                this.modRect.x = newX;
                this.modRect.y = newY;
                this.drawModBounds();
            } else {
                System.out.println("Wrong component!");
            }
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            if (this.modComp == f) {
                this.drawModBounds();
                this.setBoundsForFrame(f, this.modRect.x, this.modRect.y, this.modRect.width, this.modRect.height);
                this.modComp = null;
                this.modRect = null;
                this.graphics.dispose();
                this.graphics = null;
                this.desktop.repaint();
                this.desktop = null;
            } else {
                System.out.println("Wrong component!");
            }
        }

        @Override
        public void beginResizingFrame(JComponent f, int direction) {
            this.startMods(f);
            this.drawModBounds();
        }

        @Override
        public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            if (this.modComp == f) {
                this.drawModBounds();
                this.modRect.x = newX;
                this.modRect.y = newY;
                this.modRect.width = newWidth;
                this.modRect.height = newHeight;
                this.drawModBounds();
            } else {
                System.out.println("Wrong component!");
            }
        }

        @Override
        public void endResizingFrame(JComponent f) {
            if (this.modComp == f) {
                this.drawModBounds();
                this.setBoundsForFrame(f, this.modRect.x, this.modRect.y, this.modRect.width, this.modRect.height);
                this.modComp = null;
                this.modRect = null;
                this.graphics.dispose();
                this.graphics = null;
                this.desktop.repaint();
                this.desktop = null;
            } else {
                System.out.println("Wrong component!");
            }
        }

        private void startMods(JComponent f) {
            this.modRect = f.getBounds();
            this.modComp = f;
            this.desktop = (JDesktopPane)SwingUtilities.getAncestorOfClass(JDesktopPane.class, f);
            this.graphics = this.desktop.getGraphics();
            this.graphics.setXORMode(Color.white);
        }

        private void drawModBounds() {
            Rectangle r = this.modRect;
            for (int i = 0; i < 4; ++i) {
                this.graphics.drawRect(r.x + i, r.y + i, r.width - 2 * i, r.height - 2 * i);
            }
        }
    }

    static class OpenInternalFrameAction
    extends AbstractAction
    implements PropertyChangeListener {
        private JInternalFrame internalFrame;

        OpenInternalFrameAction(JInternalFrame internalFrame) {
            super(internalFrame.getTitle());
            this.internalFrame = internalFrame;
            internalFrame.addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                this.internalFrame.setIcon(false);
                this.internalFrame.show();
                this.internalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("title".equals(event.getPropertyName())) {
                this.putValue("Name", (String)event.getNewValue());
            }
        }
    }

    class InternalFramesWatcher
    extends InternalFrameAdapter {
        InternalFramesWatcher() {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame iframe = e.getInternalFrame();
            DesktopPane.this.internalFrames.remove(iframe);
            DesktopPane.this.removeMenuItemFor(iframe);
        }
    }
}

