/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JCheckBoxAdapter
extends ViewAspectAdapter
implements ItemListener {
    private JCheckBox viewComponent;
    private boolean fireAction = false;

    public JCheckBoxAdapter(ModelAspectId modelAspectId, JCheckBox viewComponent) {
        super(modelAspectId);
        viewComponent.setName(modelAspectId.toString());
        this.setViewComponent(viewComponent);
    }

    public JCheckBoxAdapter(ModelAspectId modelAspectId, JCheckBox viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
        this(modelAspectId, viewComponent, editRule, viewValueConverter, modelEditMediator, false);
    }

    public JCheckBoxAdapter(ModelAspectId modelAspectId, JCheckBox viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator, boolean fireAction) {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
        viewComponent.setName(modelAspectId.toString());
        this.setViewComponent(viewComponent);
        this.setFireAction(fireAction);
    }

    private void setViewComponent(JCheckBox viewComponent) {
        this.viewComponent = viewComponent;
        viewComponent.addItemListener(this);
    }

    @Override
    public Component getViewComponent() {
        return this.viewComponent;
    }

    private void setFireAction(boolean fireAction) {
        this.fireAction = fireAction;
    }

    public boolean getFireAction() {
        return this.fireAction;
    }

    @Override
    public boolean isEditable() {
        return this.viewComponent.isEnabled();
    }

    @Override
    public void setEditable(boolean editable) {
        this.viewComponent.setEnabled(editable);
    }

    @Override
    public Object getViewAspectValue() {
        return this.viewComponent.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String getViewAspectStringValue() {
        return this.viewComponent.isSelected() ? "true" : "false";
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        boolean value = false;
        if (viewAspectValue == null) {
            value = false;
        } else if (viewAspectValue instanceof Boolean) {
            value = (Boolean)viewAspectValue;
        } else {
            throw new IllegalArgumentException("value must be boolean");
        }
        if (this.viewComponent.isSelected() != value) {
            if (this.fireAction) {
                this.viewComponent.doClick();
            } else {
                this.viewComponent.setSelected(value);
            }
        }
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        boolean value = "true".equals(viewStringValue);
        this.setViewAspectValue(new Boolean(value));
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.fireChangeEvent();
    }
}

