/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JComboBoxAdapter
extends ViewAspectAdapter
implements ItemListener,
DocumentListener {
    private JComboBox viewComponent;

    public JComboBoxAdapter(ModelAspectId modelAspectId, JComboBox viewComponent) {
        super(modelAspectId);
        viewComponent.setName(modelAspectId.toString());
        this.setViewComponent(viewComponent);
    }

    public JComboBoxAdapter(ModelAspectId modelAspectId, JComboBox viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
        viewComponent.setName(modelAspectId.toString());
        this.setViewComponent(viewComponent);
    }

    private void setViewComponent(JComboBox viewComponent) {
        String[] viewStringValues;
        this.viewComponent = viewComponent;
        ViewValueConverter converter = this.getViewValueConverter();
        if (converter != null && (viewStringValues = converter.getViewStringValues()) != null) {
            this.setViewStringValues(viewStringValues);
        }
        viewComponent.addItemListener(this);
        JTextComponent tc = this.getEditorTextComponent();
        if (tc != null) {
            tc.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public Component getViewComponent() {
        return this.viewComponent;
    }

    @Override
    public boolean isEditable() {
        return this.viewComponent.isEnabled();
    }

    @Override
    public void setEditable(boolean editable) {
        this.viewComponent.setEnabled(editable);
    }

    private JTextComponent getEditorTextComponent() {
        ComboBoxEditor editor = this.viewComponent.getEditor();
        if (editor.getEditorComponent() instanceof JTextComponent) {
            return (JTextComponent)editor.getEditorComponent();
        }
        return null;
    }

    @Override
    public Object getViewAspectValue() {
        return this.viewComponent.getSelectedItem();
    }

    @Override
    public String getViewAspectStringValue() {
        return this.viewComponent.getSelectedItem().toString();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        if (viewAspectValue == null) {
            return;
        }
        if (viewAspectValue instanceof String && ((String)viewAspectValue).length() <= 0) {
            return;
        }
        this.viewComponent.setSelectedItem(viewAspectValue);
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        if (viewStringValue == null || viewStringValue.length() <= 0) {
            return;
        }
        this.viewComponent.setSelectedItem(viewStringValue);
    }

    public void setViewStringValues(String[] viewStringValues) {
        this.viewComponent.removeAllItems();
        int n = viewStringValues == null ? 0 : viewStringValues.length;
        for (int i = 0; i < n; ++i) {
            this.viewComponent.addItem(viewStringValues[i]);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }
}

