/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import java.lang.reflect.Array;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectId;

public class JListViewAspectAdapter
extends ViewAspectAdapter
implements ListDataListener {
    protected Object[] assignedViewAspectValue;
    protected Class arrayElementType;
    protected JList viewComponent;

    public JListViewAspectAdapter(ModelAspectId aspectId, JList viewComponent, Class arrayElementType) {
        this(aspectId, viewComponent, arrayElementType, null, null);
    }

    public JListViewAspectAdapter(ModelAspectId aspectId, JList viewComponent, Class arrayElementType, EditRule editRule, ModelEditMediator modelEditMediator) {
        super(aspectId, editRule, null, modelEditMediator);
        viewComponent.setName(aspectId.toString());
        this.viewComponent = viewComponent;
        viewComponent.getModel().addListDataListener(this);
        this.arrayElementType = arrayElementType;
    }

    @Override
    public Component getViewComponent() {
        return this.viewComponent;
    }

    @Override
    public Object getModelAspectValue() throws ViewValueConversionException {
        ListModel listModel = this.viewComponent.getModel();
        int size = listModel.getSize();
        Object[] result = (Object[])Array.newInstance(this.arrayElementType, size);
        for (int i = 0; i < size; ++i) {
            result[i] = listModel.getElementAt(i);
        }
        return result;
    }

    @Override
    public Object getViewAspectValue() {
        return this.viewComponent.getModel();
    }

    @Override
    public void setViewAspectValue(Object value) {
        Object[] items = (Object[])value;
        int size = items == null ? 0 : items.length;
        DefaultListModel listModel = (DefaultListModel)this.viewComponent.getModel();
        listModel.clear();
        for (int i = 0; i < size; ++i) {
            listModel.addElement(items[i]);
        }
        this.viewComponent.setModel(listModel);
    }

    @Override
    public String getViewAspectStringValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewAspectStringValue(String stringValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEditable(boolean editable) {
        this.viewComponent.setEnabled(editable);
    }

    @Override
    public boolean isEditable() {
        return this.viewComponent.isEnabled();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireChangeEvent();
    }
}

