/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JSpinnerViewAspectAdapter
extends ViewAspectAdapter
implements ChangeListener,
DocumentListener,
UndoableEditListener {
    private JSpinner viewComponent;
    private boolean fireUndoableTextEvents;

    public JSpinnerViewAspectAdapter(ModelAspectId modelAspectId, JSpinner viewComponent) {
        this(modelAspectId, viewComponent, false);
    }

    public JSpinnerViewAspectAdapter(ModelAspectId modelAspectId, JSpinner viewComponent, boolean fireUndoableTextEvents) {
        super(modelAspectId);
        viewComponent.setName(modelAspectId.toString());
        this.fireUndoableTextEvents = fireUndoableTextEvents;
        this.setViewComponent(viewComponent);
    }

    public JSpinnerViewAspectAdapter(ModelAspectId modelAspectId, JSpinner viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
        this(modelAspectId, viewComponent, editRule, viewValueConverter, modelEditMediator, false);
    }

    public JSpinnerViewAspectAdapter(ModelAspectId modelAspectId, JSpinner viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator, boolean fireUndoableTextEvents) {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
        viewComponent.setName(modelAspectId.toString());
        this.fireUndoableTextEvents = fireUndoableTextEvents;
        this.setViewComponent(viewComponent);
    }

    private void setViewComponent(JSpinner viewComponent) {
        this.viewComponent = viewComponent;
        viewComponent.addChangeListener(this);
        JFormattedTextField field = ((JSpinner.DefaultEditor)viewComponent.getEditor()).getTextField();
        field.setBorder(null);
        field.getDocument().addDocumentListener(this);
        if (this.fireUndoableTextEvents) {
            field.getDocument().addUndoableEditListener(this);
        }
    }

    @Override
    public Component getViewComponent() {
        return this.viewComponent;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public Object getViewAspectValue() {
        return this.viewComponent.getValue();
    }

    @Override
    public String getViewAspectStringValue() {
        return this.viewComponent.getValue() != null ? this.viewComponent.getValue().toString() : null;
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        if (viewAspectValue != null) {
            this.viewComponent.setValue(viewAspectValue);
        }
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        this.viewComponent.setValue(viewStringValue);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent edit) {
        if (this.fireUndoableTextEvents) {
            this.fireUndoableEditEvent(edit.getEdit());
        }
    }
}

