/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.util.ObjectCopier;
import modelobjects.util.swing.IModelTableModel;

public class JTableListAspectAdapter
extends ViewAspectAdapter
implements TableModelListener {
    private JTable table;
    protected IModelTableModel tableModel;
    protected ObjectCopier rowModelCopier;
    private boolean editable;
    private PropertyChangeSupport propertyChangeSupport;
    public static final String EDITABLE_PROPERTY = "editable";

    public JTableListAspectAdapter(ModelAspectId modelAspectId, JTable table, IModelTableModel tableModel, ObjectCopier rowModelCopier, EditRule editRule, ModelEditMediator modelEditMediator) {
        super(modelAspectId, editRule, null, modelEditMediator);
        table.setName(modelAspectId.toString());
        this.table = table;
        this.tableModel = tableModel;
        this.rowModelCopier = rowModelCopier;
        tableModel.addTableModelListener(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public Component getViewComponent() {
        return this.table;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        boolean wasEditable = this.editable;
        this.editable = editable;
        if (editable != wasEditable) {
            this.propertyChangeSupport.firePropertyChange(EDITABLE_PROPERTY, wasEditable, editable);
        }
    }

    @Override
    public Object getViewAspectValue() {
        return this.tableModel.getContents();
    }

    @Override
    public String getViewAspectStringValue() {
        throw new IllegalArgumentException("String values not supported");
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        List elems = (List)viewAspectValue;
        int numElems = elems == null ? 0 : elems.size();
        ArrayList<Object> contents = new ArrayList<Object>(numElems);
        for (int i = 0; i < numElems; ++i) {
            contents.add(this.rowModelCopier.copyObject(elems.get(i)));
        }
        this.tableModel.setContents(contents);
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        throw new IllegalArgumentException("String values not supported");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1 && e.getLastRow() == -1 && e.getColumn() == -1) {
            return;
        }
        this.fireChangeEvent();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

