/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.Component;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JTextAreaAdapter
extends ViewAspectAdapter
implements DocumentListener,
UndoableEditListener {
    private JTextArea viewComponent;
    private boolean fireUndoableTextEvents;

    public JTextAreaAdapter(ModelAspectId modelAspectId, JTextArea viewComponent) {
        this(modelAspectId, viewComponent, false);
    }

    public JTextAreaAdapter(ModelAspectId modelAspectId, JTextArea viewComponent, boolean fireUndoableTextEvents) {
        super(modelAspectId);
        viewComponent.setName(modelAspectId.toString());
        this.fireUndoableTextEvents = fireUndoableTextEvents;
        this.setViewComponent(viewComponent);
    }

    public JTextAreaAdapter(ModelAspectId modelAspectId, JTextArea viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
        this(modelAspectId, viewComponent, editRule, viewValueConverter, modelEditMediator, false);
    }

    public JTextAreaAdapter(ModelAspectId modelAspectId, JTextArea viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator, boolean fireUndoableTextEvents) {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
        viewComponent.setName(modelAspectId.toString());
        this.fireUndoableTextEvents = fireUndoableTextEvents;
        this.setViewComponent(viewComponent);
    }

    private void setViewComponent(JTextArea viewComponent) {
        this.viewComponent = viewComponent;
        viewComponent.getDocument().addDocumentListener(this);
        if (this.fireUndoableTextEvents) {
            viewComponent.getDocument().addUndoableEditListener(this);
        }
    }

    @Override
    public Component getViewComponent() {
        return this.viewComponent;
    }

    @Override
    public boolean isEditable() {
        return this.viewComponent.isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable != this.viewComponent.isEditable()) {
            this.viewComponent.setEditable(editable);
            this.viewComponent.setBackground(editable ? UIManager.getColor("TextArea.background") : UIManager.getColor("Panel.background"));
        }
    }

    @Override
    public Object getViewAspectValue() {
        return this.viewComponent.getText();
    }

    @Override
    public String getViewAspectStringValue() {
        return this.viewComponent.getText();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        if (viewAspectValue == null) {
            this.setComponentText("");
        } else if (viewAspectValue instanceof String) {
            this.setComponentText((String)viewAspectValue);
        } else {
            throw new IllegalArgumentException("value must be a String");
        }
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        if (viewStringValue == null) {
            this.setComponentText("");
        } else {
            this.setComponentText(viewStringValue);
        }
    }

    private void setComponentText(String text) {
        this.viewComponent.setText(text);
        this.viewComponent.setCaretPosition(0);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent edit) {
        if (this.fireUndoableTextEvents) {
            this.fireUndoableEditEvent(edit.getEdit());
        }
    }
}

