/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.TextAction;
import modelobjects.framework.swing.MessagePaneLogHandler;

public class MessagePane
extends JTextPane {
    protected Action cutAction;
    protected Action copyAction;
    protected Action clearAction;
    protected Action selectAllAction;
    private transient Icon informIcon;
    private transient Icon statusIcon;
    private transient Icon warningIcon;
    private transient Icon errorIcon;
    private transient boolean iconsReady = false;
    private static final int alignment = 0;
    private static final int normalFontSize = 14;
    private static final float tab = 40.0f;
    private static final float margin = 2.0f;
    private static final float rightMargin = 20.0f;
    private static final String INFORM_ICON = "OptionPane.informationIcon";
    private static final String STATUS_ICON = "none";
    private static final String WARNING_ICON = "OptionPane.warningIcon";
    private static final String ERROR_ICON = "OptionPane.errorIcon";
    private static final String EXCEPTION_PROP = "exception";
    private static final String MESSAGE_PROP = "message";
    private static final String NORMAL_STYLE = "normal";
    private static final String INDENT_STYLE = "indented";
    private static final String INFORMATION_STYLE = "inform";
    private static final String STATUS_STYLE = "status";
    private static final String WARNING_STYLE = "warning";
    private static final String ERROR_STYLE = "error";
    private static final String STACKTRACE_STYLE = "stacktrace";
    private static final String HEADER_STYLE = "headerInfo";

    public MessagePane() {
        this.prepareMessagePane();
    }

    private void prepareMessagePane() {
        this.setEditable(false);
        this.initActions();
        this.initTextStyles();
        TextEventHandler eventHandler = new TextEventHandler();
        this.addCaretListener(eventHandler);
        this.getDocument().addDocumentListener(eventHandler);
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getClearAction() {
        return this.clearAction;
    }

    public Action getSelectAllAction() {
        return this.selectAllAction;
    }

    public synchronized void addStatusMessage(String message, Throwable throwable) {
        this.addMessage(this, this.getIcon(STATUS_ICON), this.getStyle(STATUS_STYLE), message, throwable);
    }

    public synchronized void addInformatoryMessage(String message, Throwable throwable) {
        this.addMessage(this, this.getIcon(INFORM_ICON), this.getStyle(INFORMATION_STYLE), message, throwable);
    }

    public synchronized void addWarningMessage(String message, Throwable throwable) {
        this.addMessage(this, this.getIcon(WARNING_ICON), this.getStyle(WARNING_STYLE), message, throwable);
    }

    public synchronized void addErrorMessage(String message, Throwable throwable) {
        this.addMessage(this, this.getIcon(ERROR_ICON), this.getStyle(ERROR_STYLE), message, throwable);
    }

    public synchronized void addToLastMessage(String message, Throwable throwable) {
        SwingUtilities.invokeLater(new MessageAppender(message, throwable));
    }

    protected void initActions() {
        Action[] actions = this.getActions();
        this.clearAction = new TextAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTextComponent textComp = this.getTextComponent(event);
                textComp.selectAll();
                textComp.setText("");
                for (int i = MessagePane.this.getComponentCount() - 1; i >= 0; --i) {
                    Component comp = MessagePane.this.getComponent(i);
                    if (!(comp instanceof JButton)) continue;
                    MessagePane.this.remove(comp);
                }
            }
        };
        this.copyAction = new TextAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent event) {
                this.getTextComponent(event).copy();
            }
        };
        this.cutAction = new TextAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTextComponent textComp = this.getTextComponent(event);
                textComp.copy();
                Document doc = textComp.getDocument();
                try {
                    int p1 = textComp.getSelectionStart();
                    int p2 = textComp.getSelectionEnd();
                    doc.remove(Math.min(p1, p2), Math.abs(p2 - p1));
                }
                catch (BadLocationException badLoc) {
                    // empty catch block
                }
            }
        };
        this.selectAllAction = new TextAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent event) {
                this.getTextComponent(event).selectAll();
                this.getTextComponent(event).requestFocus();
            }
        };
    }

    private KeyStroke getActionKeyBinding(Action action) {
        Keymap keymap = this.getKeymap();
        KeyStroke[] boundKeys = keymap.getBoundKeyStrokes();
        int numKeyStrokes = boundKeys == null ? 0 : boundKeys.length;
        for (int i = 0; i < numKeyStrokes; ++i) {
            if (keymap.getAction(boundKeys[i]) != action) continue;
            return boundKeys[i];
        }
        return null;
    }

    protected void initTextStyles() {
        int numTabStops = 8;
        TabStop[] tabStops = new TabStop[8];
        for (int i = 0; i < 8; ++i) {
            tabStops[i] = new TabStop(40.0f * (float)i);
        }
        TabSet tabs = new TabSet(tabStops);
        MessagePane textPane = this;
        Style baseStyle = textPane.getLogicalStyle();
        Style normalStyle = textPane.addStyle(NORMAL_STYLE, baseStyle);
        StyleConstants.setFontSize(normalStyle, 14);
        StyleConstants.setFontFamily(normalStyle, "SansSerif");
        StyleConstants.setBold(normalStyle, false);
        StyleConstants.setItalic(normalStyle, false);
        StyleConstants.setAlignment(normalStyle, 0);
        StyleConstants.setRightIndent(normalStyle, 20.0f);
        StyleConstants.setLeftIndent(normalStyle, 2.0f);
        StyleConstants.setTabSet(normalStyle, tabs);
        StyleConstants.setSpaceAbove(normalStyle, 8.0f);
        StyleConstants.setSpaceBelow(normalStyle, 0.0f);
        Style indented = textPane.addStyle(INDENT_STYLE, normalStyle);
        StyleConstants.setLeftIndent(indented, 40.0f);
        Style style = textPane.addStyle(STATUS_STYLE, indented);
        StyleConstants.setForeground(style, Color.black);
        style = textPane.addStyle(INFORMATION_STYLE, indented);
        StyleConstants.setForeground(style, Color.black);
        StyleConstants.setItalic(style, true);
        style = textPane.addStyle(WARNING_STYLE, indented);
        StyleConstants.setBold(style, true);
        StyleConstants.setItalic(style, true);
        StyleConstants.setForeground(style, Color.blue);
        style = textPane.addStyle(ERROR_STYLE, indented);
        StyleConstants.setBold(style, true);
        StyleConstants.setFontSize(style, 16);
        StyleConstants.setForeground(style, Color.red);
        style = textPane.addStyle(STACKTRACE_STYLE, normalStyle);
        StyleConstants.setFontFamily(style, "Monospaced");
        StyleConstants.setFontSize(style, 12);
        StyleConstants.setForeground(style, Color.blue);
        StyleConstants.setBold(style, false);
        StyleConstants.setItalic(style, false);
        StyleConstants.setSpaceAbove(style, 0.0f);
        StyleConstants.setSpaceBelow(style, 0.0f);
        StyleConstants.setLeftIndent(style, 42.0f);
        style = textPane.addStyle(HEADER_STYLE, style);
        StyleConstants.setForeground(style, Color.darkGray);
        StyleConstants.setSpaceAbove(style, 16.0f);
        StyleConstants.setLeftIndent(style, 2.0f);
    }

    protected Icon getIcon(String iconName) {
        if (!this.iconsReady) {
            this.informIcon = UIManager.getIcon(INFORM_ICON);
            this.statusIcon = UIManager.getIcon(STATUS_ICON);
            this.warningIcon = UIManager.getIcon(WARNING_ICON);
            this.errorIcon = UIManager.getIcon(ERROR_ICON);
            this.iconsReady = true;
        }
        if (iconName.equals(STATUS_ICON)) {
            return this.statusIcon;
        }
        if (iconName.equals(INFORM_ICON)) {
            return this.informIcon;
        }
        if (iconName.equals(WARNING_ICON)) {
            return this.warningIcon;
        }
        if (iconName.equals(ERROR_ICON)) {
            return this.errorIcon;
        }
        return null;
    }

    protected void addMessage(JTextPane textPane, Icon icon, Style style, String msg, Throwable throwable) {
        if (msg == null || msg.equals("") || msg.equals("Ready")) {
            return;
        }
        if (System.getProperty("NOMESSAGELOG") != null) {
            System.out.println(msg);
        } else {
            SwingUtilities.invokeLater(new MessageAdder(textPane, icon, style, msg, throwable));
        }
    }

    protected void addStackTraceButton(int textStart, Icon icon, Style style, String message, Throwable throwable) {
        String label = "Show Stack Trace...";
        JButton button = new JButton(label);
        button.setOpaque(true);
        button.addActionListener(new StackTraceButtonHandler(icon, style, message, throwable));
        button.putClientProperty(EXCEPTION_PROP, throwable);
        button.putClientProperty(MESSAGE_PROP, message);
        SimpleAttributeSet componentAttrs = new SimpleAttributeSet();
        StyleConstants.setComponent(componentAttrs, button);
        StyledDocument doc = this.getStyledDocument();
        int end = doc.getLength();
        this.setCaretPosition(end);
        try {
            Style prevStyle = this.getLogicalStyle();
            doc.insertString(end, " ", componentAttrs);
            doc.insertString(doc.getLength(), "\n", prevStyle);
        }
        catch (BadLocationException badLoc) {
            badLoc.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame window = new JFrame("MessagePane Test");
        window.setDefaultCloseOperation(3);
        window.setBounds(200, 200, 600, 500);
        MessagePane msgPane = new MessagePane();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new JButton(msgPane.getCutAction()));
        buttonPanel.add(new JButton(msgPane.getCopyAction()));
        buttonPanel.add(new JButton(msgPane.getClearAction()));
        buttonPanel.add(new JButton(msgPane.getSelectAllAction()));
        window.getContentPane().add((Component)new JScrollPane(msgPane), "Center");
        window.getContentPane().add((Component)buttonPanel, "South");
        window.setVisible(true);
        if (args.length == 1 && args[0].equals("-logger")) {
            MessagePaneLogHandler logHandler = new MessagePaneLogHandler(msgPane);
            Logger testLogger = Logger.getLogger("test");
            testLogger.setLevel(Level.ALL);
            testLogger.addHandler(logHandler);
            testLogger.log(Level.FINE, "OK, we're just starting up now...", (Throwable)null);
            testLogger.log(Level.INFO, "Now here's some information for you!", (Throwable)null);
            testLogger.log(Level.WARNING, "Let this be a warning to you!", new Exception("Condition YELLOW"));
            testLogger.log(Level.SEVERE, "Danger, Danger Will Robinson!", new Exception("Condition RED"));
        } else {
            msgPane.addStatusMessage("Ok, are we having fun yet?", null);
            msgPane.addInformatoryMessage("Hey, here's some info.", null);
            msgPane.addWarningMessage("Hey, this is a warning, buddy!", new Exception("That was a warning"));
            msgPane.addErrorMessage("Hey, this is an error!", new Exception("That was an error"));
        }
    }

    private class StackTraceButtonHandler
    implements ActionListener,
    Serializable {
        private Icon icon;
        private Style style;
        private String message;
        private Throwable throwable;

        StackTraceButtonHandler(Icon icon, Style style, String message, Throwable throwable) {
            this.icon = icon;
            this.style = style;
            this.message = message;
            this.throwable = throwable;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JButton button = (JButton)evt.getSource();
            Style stacktraceStyle = MessagePane.this.getStyle(MessagePane.STACKTRACE_STYLE);
            try {
                this.throwable = new Exception(this.throwable.getMessage());
                StringWriter writer = new StringWriter();
                this.throwable.printStackTrace(new PrintWriter(writer));
                String stackTrace = writer.toString();
                JTextPane stackTracePane = new JTextPane(){

                    @Override
                    public boolean getScrollableTracksViewportWidth() {
                        return false;
                    }
                };
                stackTracePane.setEditable(false);
                stackTracePane.getStyledDocument().insertString(0, stackTrace, stacktraceStyle);
                JScrollPane scroller = new JScrollPane(stackTracePane, 22, 32);
                scroller.setPreferredSize(new Dimension(650, 300));
                stackTracePane.setCaretPosition(0);
                JPanel outerPanel = new JPanel();
                JTextPane messagePane = new JTextPane();
                messagePane.setBackground(UIManager.getColor("Panel.background"));
                messagePane.setEditable(false);
                new MessageAdder(messagePane, this.icon, this.style, this.message, null).run();
                outerPanel.setLayout(new BorderLayout());
                outerPanel.add(messagePane);
                outerPanel.add((Component)scroller, "South");
                String exceptionMessage = this.throwable.getMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = "Exception";
                }
                JOptionPane.showMessageDialog(MessagePane.this, outerPanel, "Stack Trace for: " + exceptionMessage, -1);
                MessagePane.this.requestFocus();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    protected class MessageAppender
    implements Runnable {
        String message;
        Throwable throwable;

        MessageAppender(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        @Override
        public void run() {
            MessagePane textPane = MessagePane.this;
            StyledDocument doc = textPane.getStyledDocument();
            int end = doc.getLength();
            textPane.setCaretPosition(end);
            Style style = doc.getLogicalStyle(end);
            try {
                doc.insertString(end, this.message, style);
                if (this.throwable != null) {
                    MessagePane.this.addStackTraceButton(end, null, style, this.message, this.throwable);
                }
                textPane.setLogicalStyle(style);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    protected class MessageAdder
    implements Runnable {
        JTextPane textPane;
        Icon icon;
        Style style;
        String message;
        Throwable throwable;
        String threadName;
        Date eventTime;
        long millis;

        MessageAdder(JTextPane textPane, Icon icon, Style style, String message, Throwable throwable) {
            if (message != null && !message.endsWith("\n")) {
                message = message + "\n";
            }
            this.textPane = textPane;
            this.icon = icon;
            this.style = style;
            this.message = message;
            this.throwable = throwable;
            this.threadName = Thread.currentThread().getName();
            this.eventTime = new Date();
            this.millis = System.currentTimeMillis();
        }

        @Override
        public void run() {
            try {
                StyledDocument doc = this.textPane.getStyledDocument();
                int end = doc.getLength();
                SimpleAttributeSet iconAttrs = new SimpleAttributeSet();
                if (end > 0 && this.textPane.getText(end - 1, 1).charAt(0) != '\n') {
                    doc.insertString(end++, "\n", this.style);
                }
                if (this.icon != null) {
                    StyleConstants.setIcon(iconAttrs, this.icon);
                }
                this.textPane.setCaretPosition(end);
                Style headerStyle = MessagePane.this.getStyle(MessagePane.HEADER_STYLE);
                this.textPane.setLogicalStyle(headerStyle);
                doc.insertString(end, " ", iconAttrs);
                String headerText = "\t";
                if (this.textPane == MessagePane.this) {
                    DateFormat df = DateFormat.getTimeInstance(1);
                    df.setTimeZone(TimeZone.getDefault());
                    String time = df.format(this.eventTime);
                    time = time + " + " + this.millis % 1000L + " msec";
                    headerText = "\t" + time + " -- thread " + this.threadName + "\n";
                }
                doc.insertString(end + 1, headerText, headerStyle);
                this.textPane.setCaretPosition(doc.getLength());
                this.textPane.setLogicalStyle(this.style);
                this.textPane.setParagraphAttributes(this.style, true);
                doc.insertString(end + headerText.length() + 1, this.message, this.style);
                if (this.throwable != null) {
                    MessagePane.this.addStackTraceButton(end + headerText.length() + 1, this.icon, this.style, this.message, this.throwable);
                }
            }
            catch (BadLocationException badLoc) {
                badLoc.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Unexpected exception in MessageAdder: " + e);
            }
        }
    }

    protected class TextEventHandler
    implements CaretListener,
    DocumentListener {
        protected TextEventHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int p1 = MessagePane.this.getSelectionStart();
            int p2 = MessagePane.this.getSelectionEnd();
            MessagePane.this.cutAction.setEnabled(p1 != p2);
            MessagePane.this.copyAction.setEnabled(p1 != p2);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MessagePane.this.clearAction.setEnabled(true);
            MessagePane.this.selectAllAction.setEnabled(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            int end = MessagePane.this.getDocument().getLength();
            MessagePane.this.clearAction.setEnabled(end > 0);
            MessagePane.this.selectAllAction.setEnabled(end > 0);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

