/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import modelobjects.framework.swing.MessagePane;

public class MessagePaneLogHandler
extends Handler {
    private MessagePane messagePane;

    MessagePaneLogHandler(MessagePane messagePane) {
        this.messagePane = messagePane;
        this.setFormatter();
    }

    private void setFormatter() {
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (this.messagePane == null) {
            return;
        }
        int errorLevel = logRecord.getLevel().intValue();
        String message = this.getFormatter().format(logRecord);
        Throwable error = logRecord.getThrown();
        if (errorLevel < Level.INFO.intValue()) {
            this.messagePane.addStatusMessage(message, error);
        } else if (errorLevel == Level.INFO.intValue()) {
            this.messagePane.addInformatoryMessage(message, error);
        } else if (errorLevel == Level.WARNING.intValue()) {
            this.messagePane.addWarningMessage(message, error);
        } else if (errorLevel >= Level.SEVERE.intValue()) {
            this.messagePane.addErrorMessage(message, error);
        }
    }

    @Override
    public void close() {
        this.messagePane = null;
    }

    @Override
    public void flush() {
    }
}

