/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import modelobjects.layout.PartitionLayout;

public class StatusBar
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private int numExtras = 11;
    private int timeFieldIndex = 10;
    private transient Timer wallclockTimer;
    private transient Timer progressTimer;
    private JTextField statusArea;
    private JLabel[] extras;
    private JButton cancelButton;
    private JProgressBar progressBar;
    private boolean progressBarTracksCancelButton;
    private static Border STATUS_FIELD_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2));

    public StatusBar() {
        this((JButton)null);
    }

    public StatusBar(JButton cancelButton) {
        this(cancelButton, StatusBar.makeDefaultProgressBar());
    }

    public StatusBar(JButton cancelButton, JProgressBar progressBar) {
        this.cancelButton = cancelButton;
        this.progressBar = progressBar;
        this.buildComponents();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public static JProgressBar makeDefaultProgressBar() {
        JProgressBar progressBar = new JProgressBar(0, 8);
        progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        progressBar.setString("Working...");
        return progressBar;
    }

    public boolean getProgressBarTracksCancelButton() {
        return this.progressBarTracksCancelButton;
    }

    public void setProgressBarTracksCancelButton(boolean val) {
        if (this.progressBarTracksCancelButton != val) {
            this.progressBarTracksCancelButton = val;
            if (this.cancelButton != null && this.progressBar != null) {
                if (val) {
                    this.cancelButton.addPropertyChangeListener(this);
                } else {
                    this.cancelButton.removePropertyChangeListener(this);
                }
            }
        }
    }

    public void showStatusMessage(String message) {
        String text = message == null ? "" : message;
        this.updateText(this.statusArea, text);
    }

    public void setStatusFieldSizeInChars(int statusFieldNumber, int numChars) {
        FontMetrics fm;
        Font f;
        Dimension sz = new Dimension(40, 16);
        JLabel comp = this.extras[statusFieldNumber];
        Insets m = comp.getInsets();
        if (numChars > 0 && (f = comp.getFont()) != null && (fm = this.getFontMetrics(f)) != null) {
            sz = new Dimension(fm.charWidth('N') * numChars, fm.getHeight());
        }
        sz.width += m.left + m.right;
        sz.height += m.top + m.bottom;
        comp.setPreferredSize(sz);
        comp.setVisible(numChars > 0);
        this.invalidate();
        this.validate();
    }

    public String getStatusField(int statusFieldNumber) {
        return this.extras[statusFieldNumber].getText();
    }

    public void setStatusField(int statusFieldNumber, String text) {
        this.updateText(this.extras[statusFieldNumber], text);
    }

    public void showTimeOfDay(boolean show) {
        if (show) {
            this.extras[this.timeFieldIndex].setHorizontalAlignment(0);
            this.setStatusFieldSizeInChars(this.timeFieldIndex, 10);
            if (this.wallclockTimer == null) {
                this.wallclockTimer = new Timer(1000, this);
                this.wallclockTimer.setRepeats(true);
            }
            this.wallclockTimer.start();
        } else {
            if (this.wallclockTimer != null) {
                this.wallclockTimer.stop();
            }
            this.setStatusFieldSizeInChars(this.timeFieldIndex, 0);
        }
    }

    @Override
    public void removeNotify() {
        if (this.progressTimer != null) {
            this.progressTimer.stop();
            this.progressTimer = null;
        }
        if (this.wallclockTimer != null) {
            this.wallclockTimer.stop();
            this.wallclockTimer = null;
        }
        super.removeNotify();
    }

    protected void updateText(JComponent comp, String text) {
        SwingUtilities.invokeLater(new TextUpdater(comp, text));
    }

    public synchronized void monitorProgress(boolean start) {
        if (start) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setStringPainted(false);
            this.progressBar.setIndeterminate(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.cancelButton != null && this.progressBar != null && event.getSource() == this.cancelButton && event.getPropertyName().equals("enabled")) {
            this.monitorProgress(this.cancelButton.isEnabled());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.wallclockTimer) {
            DateFormat df = DateFormat.getTimeInstance(2);
            df.setTimeZone(TimeZone.getDefault());
            String time = df.format(new Date());
            if (!this.getStatusField(this.timeFieldIndex).equals(time)) {
                this.setStatusField(this.timeFieldIndex, time);
            }
        } else if (event.getSource() == this.progressTimer) {
            if (this.progressBar.getValue() < this.progressBar.getMaximum()) {
                this.progressBar.setValue(this.progressBar.getValue() + 1);
            } else {
                this.progressBar.setValue(0);
            }
        }
    }

    private void buildComponents() {
        this.setLayout(new BorderLayout(2, 2));
        JPanel p = new JPanel();
        p.setLayout(new PartitionLayout(false, "Rppppppppppp", 2, 1, 1, "status"));
        this.add((Component)p, "Center");
        this.statusArea = new JTextField("");
        this.statusArea.setEditable(false);
        this.statusArea.setOpaque(true);
        this.statusArea.setBackground(Color.white);
        this.statusArea.setBorder(STATUS_FIELD_BORDER);
        if (this.cancelButton != null) {
            this.add((Component)this.cancelButton, "West");
        }
        p.add(this.statusArea);
        if (this.progressBar != null) {
            --this.numExtras;
            --this.timeFieldIndex;
        }
        this.extras = new JLabel[this.numExtras];
        for (int i = 0; i < this.numExtras; ++i) {
            JLabel lbl = this.extras[i] = new JLabel();
            lbl.setBorder(STATUS_FIELD_BORDER);
            lbl.setVisible(false);
            p.add(lbl);
        }
        if (this.progressBar != null) {
            p.add(this.progressBar);
        }
    }

    public static void main(String[] args) {
        JFrame window = new JFrame("StatusBar Test");
        window.setDefaultCloseOperation(3);
        window.setBounds(300, 300, 700, 400);
        JButton cancelButton = new JButton("Cancel");
        final StatusBar statusBar = new StatusBar(cancelButton);
        statusBar.setStatusFieldSizeInChars(0, 2);
        statusBar.setStatusFieldSizeInChars(1, 4);
        statusBar.setStatusFieldSizeInChars(2, 6);
        statusBar.setStatusFieldSizeInChars(3, 8);
        statusBar.setStatusField(0, "NN");
        statusBar.setStatusField(1, "NNNN");
        statusBar.setStatusField(2, "NNNNNN");
        statusBar.setStatusField(3, "Whassup?");
        statusBar.showTimeOfDay(true);
        cancelButton.addActionListener(new ActionListener(){
            boolean running = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.running = !this.running;
                statusBar.monitorProgress(this.running);
            }
        });
        window.getContentPane().add((Component)statusBar, "South");
        window.setVisible(true);
    }

    static class TextUpdater
    implements Runnable {
        private Component comp;
        private String text;

        public TextUpdater(JComponent comp, String text) {
            this.comp = comp;
            this.text = text;
        }

        @Override
        public void run() {
            if (this.comp instanceof JTextField) {
                ((JTextField)this.comp).setText(this.text);
            } else if (this.comp instanceof JLabel) {
                ((JLabel)this.comp).setText(this.text);
            }
        }
    }
}

