/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.threads;

import modelobjects.framework.threads.ThreadEventListener;
import modelobjects.framework.threads.ThreadListenerSupport;

public class CancellableThread
extends Thread {
    private static int uniqueIdCounter = 1;
    private Runnable innerRunnable;
    private RunnableRunner runnableRunner;
    private Integer uniqueID;
    private boolean cancelled = false;

    public CancellableThread(Runnable innerRunnable, String threadName) {
        this(threadName, new RunnableRunner(innerRunnable));
        this.innerRunnable = innerRunnable;
    }

    private CancellableThread(String threadName, RunnableRunner runnableRunner) {
        super((Runnable)runnableRunner, threadName);
        runnableRunner.setCancellableThread(this);
        this.uniqueID = new Integer(CancellableThread.getNextUniqueId());
        this.runnableRunner = runnableRunner;
    }

    public Runnable getInnerRunnable() {
        return this.innerRunnable;
    }

    public boolean isCancellable() {
        return true;
    }

    public RunnableRunner getRunnableRunner() {
        return this.runnableRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        CancellableThread cancellableThread = this;
        synchronized (cancellableThread) {
            this.cancelled = true;
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        if (this.cancelled) {
            return true;
        }
        CancellableThread cancellableThread = this;
        synchronized (cancellableThread) {
            return this.cancelled;
        }
    }

    public boolean wasStarted() {
        return this.runnableRunner.wasStarted();
    }

    public static boolean isThreadCancelled() {
        Thread t = Thread.currentThread();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            t.interrupt();
        }
        if (t instanceof CancellableThread) {
            return ((CancellableThread)t).isCancelled();
        }
        return t.isInterrupted();
    }

    public boolean terminate(long maxWaitToDie) {
        if (!this.isAlive()) {
            return true;
        }
        this.cancel();
        try {
            this.join(maxWaitToDie);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isAlive()) {
            return true;
        }
        this.stop();
        return false;
    }

    public void addThreadEventListener(ThreadEventListener listener) {
        this.runnableRunner.addThreadEventListener(listener);
    }

    public void removeThreadEventListener(ThreadEventListener listener) {
        this.runnableRunner.removeThreadEventListener(listener);
    }

    public String getThreadCompletedText() {
        return this.runnableRunner.getThreadCompletedText();
    }

    public void setThreadCompletedText(String text) {
        this.runnableRunner.setThreadCompletedText(text);
    }

    public Integer getUniqueId() {
        return this.uniqueID;
    }

    private static synchronized int getNextUniqueId() {
        return uniqueIdCounter++;
    }

    private static class RunnableRunner
    implements Runnable {
        private boolean started;
        private Runnable innerRunnable;
        private CancellableThread thread;
        private ThreadListenerSupport threadListenerSupport;
        private String threadCompletedText;

        RunnableRunner(Runnable innerRunnable) {
            this.innerRunnable = innerRunnable;
            this.threadListenerSupport = new ThreadListenerSupport();
            this.threadCompletedText = "";
        }

        Runnable getInnerRunnable() {
            return this.innerRunnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.started = true;
            Throwable throwable = null;
            try {
                this.threadListenerSupport.fireThreadStarted(this.innerRunnable, this.thread);
                this.innerRunnable.run();
            }
            catch (RuntimeException e) {
                throwable = e;
            }
            catch (ThreadDeath t) {
                throwable = t;
            }
            finally {
                RunnableRunner e = this;
                synchronized (e) {
                    this.notifyAll();
                }
                this.threadListenerSupport.fireThreadCompleted(this.innerRunnable, this.thread, throwable, this.getThreadCompletedText());
            }
        }

        public void addThreadEventListener(ThreadEventListener listener) {
            this.threadListenerSupport.addListener(listener);
        }

        public void removeThreadEventListener(ThreadEventListener listener) {
            this.threadListenerSupport.removeListener(listener);
        }

        public boolean wasStarted() {
            return this.started;
        }

        public void setThreadCompletedText(String text) {
            this.threadCompletedText = text;
        }

        public String getThreadCompletedText() {
            return this.threadCompletedText;
        }

        void setCancellableThread(CancellableThread thread) {
            this.thread = thread;
        }
    }
}

