/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.threads;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import modelobjects.framework.threads.CancellableThread;
import modelobjects.framework.threads.ThreadEvent;
import modelobjects.framework.threads.ThreadEventListener;
import modelobjects.framework.threads.ThreadListenerSupport;

public class CancellableThreadManager
implements Serializable {
    private ThreadListenerSupport threadListenerSupport = new ThreadListenerSupport();
    private Action cancelAction;
    private transient ThreadWatcher threadWatcher = new ThreadWatcher();

    public CancellableThreadManager() {
        this.cancelAction = new CancelAction();
    }

    public Action getCancelAllAction() {
        return this.cancelAction;
    }

    public CancellableThread createCancellableThread(Runnable runnable, String threadName) {
        CancellableThread thread = new CancellableThread(runnable, threadName);
        thread.addThreadEventListener(this.getThreadWatcher());
        return thread;
    }

    public CancellableThread createCancellableThread(Runnable runnable, String threadName, String threadCompletedText) {
        CancellableThread thread = this.createCancellableThread(runnable, threadName);
        thread.setThreadCompletedText(threadCompletedText);
        return thread;
    }

    public CancellableThread createCancellableThread(Runnable runnable, String threadName, int threadPriority) {
        CancellableThread thread = this.createCancellableThread(runnable, threadName);
        thread.setPriority(threadPriority);
        return thread;
    }

    public CancellableThread createCancellableThread(Runnable runnable, String threadName, String threadCompletedText, int threadPriority) {
        CancellableThread thread = this.createCancellableThread(runnable, threadName);
        thread.setThreadCompletedText(threadCompletedText);
        thread.setPriority(threadPriority);
        return thread;
    }

    public void addThreadEventListener(ThreadEventListener listener) {
        this.threadListenerSupport.addListener(listener);
    }

    public void removeThreadEventListener(ThreadEventListener listener) {
        this.threadListenerSupport.removeListener(listener);
    }

    private ThreadWatcher getThreadWatcher() {
        if (this.threadWatcher == null) {
            this.threadWatcher = new ThreadWatcher();
        }
        return this.threadWatcher;
    }

    protected class ThreadWatcher
    implements ThreadEventListener {
        private ArrayList activeThreads = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadStarted(ThreadEvent event) {
            ThreadWatcher threadWatcher = this;
            synchronized (threadWatcher) {
                this.activeThreads.add(event.getThread());
            }
            CancellableThreadManager.this.cancelAction.setEnabled(true);
            CancellableThreadManager.this.threadListenerSupport.fireThreadStarted(event.getRunnable(), event.getThread());
        }

        public int getNumActiveThreads() {
            return this.activeThreads.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadCompleted(ThreadEvent event) {
            ThreadWatcher threadWatcher = this;
            synchronized (threadWatcher) {
                this.activeThreads.remove(event.getThread());
            }
            CancellableThreadManager.this.cancelAction.setEnabled(!this.activeThreads.isEmpty());
            CancellableThreadManager.this.threadListenerSupport.fireThreadCompleted(event.getRunnable(), event.getThread(), event.getThrowable());
        }

        public void cancelAll() {
            this.cancelAll(10000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAll(long millisecondsToWait) {
            CancellableThread thread;
            int i;
            ArrayList threads = null;
            ThreadWatcher threadWatcher = this;
            synchronized (threadWatcher) {
                threads = new ArrayList(this.activeThreads);
            }
            int n = threads.size();
            for (i = 0; i < n; ++i) {
                thread = (CancellableThread)threads.get(i);
                if (!thread.isAlive()) continue;
                thread.cancel();
            }
            n = threads.size();
            for (i = 0; i < n; ++i) {
                thread = (CancellableThread)threads.get(i);
                if (!thread.isAlive()) continue;
                thread.terminate(millisecondsToWait);
            }
        }
    }

    protected class CancelAction
    extends AbstractAction
    implements Serializable {
        public CancelAction() {
            super("Stop");
            this.setEnabled();
        }

        private void setEnabled() {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CancellableThreadManager.this.threadWatcher.cancelAll(20000L);
        }
    }
}

