/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.threads;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import modelobjects.framework.swing.StatusBar;
import modelobjects.framework.threads.CancellableThread;
import modelobjects.framework.threads.CancellableThreadManager;

public class CancellableThreadTest
extends JFrame
implements ActionListener {
    private CancellableThreadManager threadMgr;

    public CancellableThreadTest() {
        super("CancellableThreadTest");
        this.prepareCancellableThreadTest();
    }

    private void prepareCancellableThreadTest() {
        this.setDefaultCloseOperation(3);
        this.threadMgr = new CancellableThreadManager();
        JButton cancelButton = new JButton(this.threadMgr.getCancelAllAction());
        StatusBar statusBar = new StatusBar(cancelButton);
        statusBar.setProgressBarTracksCancelButton(true);
        JButton startButton = new JButton("Start");
        startButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout(8, 8));
        this.getContentPane().add((Component)startButton, "West");
        this.getContentPane().add((Component)statusBar, "South");
        this.setBounds(300, 300, 700, 200);
        this.addNotify();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CancellableThread thread = this.threadMgr.createCancellableThread(new FiboPrinter(), "FiboThread");
        thread.start();
    }

    public static void main(String[] args) {
        new CancellableThreadTest().setVisible(true);
    }

    class FiboPrinter
    implements Runnable {
        FiboPrinter() {
        }

        @Override
        public void run() {
            long a = 0L;
            long b = 1L;
            for (int i = 0; i < 2000 && !CancellableThread.isThreadCancelled(); ++i) {
                long n = a + b;
                System.out.println("Fibo[" + i + "] = " + a);
                a = b;
                b = n;
            }
        }
    }
}

