/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.framework.threads;

import modelobjects.framework.threads.CancellableThread;
import modelobjects.framework.threads.ThreadEvent;
import modelobjects.framework.threads.ThreadEventListener;
import modelobjects.util.CommonEventSupport;

public class ThreadListenerSupport
extends CommonEventSupport {
    public void addListener(ThreadEventListener listener) {
        this.addEventListener(listener);
    }

    public void removeListener(ThreadEventListener listener) {
        this.removeEventListener(listener);
    }

    public void fireThreadStarted(Runnable eventSource, CancellableThread thread) {
        if (this.anyListeners()) {
            ThreadEvent event = new ThreadEvent(eventSource, thread);
            this.fireEvent(ThreadEventListener.class, "threadStarted", event);
        }
    }

    public void fireThreadCompleted(Runnable eventSource, CancellableThread thread, Throwable throwable) {
        if (this.anyListeners()) {
            ThreadEvent event = new ThreadEvent(eventSource, thread, throwable);
            this.fireEvent(ThreadEventListener.class, "threadCompleted", event);
        }
    }

    public void fireThreadCompleted(Runnable eventSource, CancellableThread thread, Throwable throwable, String threadCompletedText) {
        if (this.anyListeners()) {
            ThreadEvent event = new ThreadEvent(eventSource, thread, throwable);
            event.setThreadCompletedText(threadCompletedText);
            this.fireEvent(ThreadEventListener.class, "threadCompleted", event);
        }
    }
}

