/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.StringTokenizer;
import modelobjects.layout.Orientation;

public class PartitionLayout
implements LayoutManager,
Serializable {
    public static final int REMAINDER = -1;
    public static final int PREFERRED = -2;
    public static final boolean TOP_TO_BOTTOM = true;
    public static final boolean LEFT_TO_RIGHT = false;
    private boolean layoutVertically;
    private int[] sectionSizes;
    private String instanceName;
    private transient Component[] savedInfo;
    private Orientation orientation;
    private int tbEdgeGap;
    private int lrEdgeGap;
    private int sepGap;
    private int splitterGap;
    private boolean useSplitters;

    public PartitionLayout() {
        this(false, "", 0);
    }

    public PartitionLayout(boolean layoutVertically, int[] sectionSizes) {
        this(layoutVertically, sectionSizes, 0);
    }

    public PartitionLayout(boolean layoutVertically, int[] sectionSizes, int gapSize) {
        this(layoutVertically, sectionSizes, gapSize, gapSize, gapSize, "Unnamed");
    }

    public PartitionLayout(boolean layoutVertically, int[] sectionSizes, int gapSize, String instanceName) {
        this(layoutVertically, sectionSizes, gapSize, gapSize, gapSize, instanceName);
    }

    public PartitionLayout(boolean layoutVertically, String encodedSizes, int gapSize) {
        this(layoutVertically, PartitionLayout.decodeSizes(encodedSizes), gapSize, gapSize, gapSize, "Unnamed");
    }

    public PartitionLayout(boolean layoutVertically, String encodedSizes, int gapSize, int tbEdgeGap, int lrEdgeGap, String instanceName) {
        this(layoutVertically, PartitionLayout.decodeSizes(encodedSizes), gapSize, tbEdgeGap, lrEdgeGap, instanceName);
    }

    public PartitionLayout(boolean layoutVertically, int[] sectionSizes, int sepGap, int tbEdgeGap, int lrEdgeGap, String instanceName) {
        this.layoutVertically = layoutVertically;
        this.sectionSizes = sectionSizes;
        this.sepGap = sepGap;
        this.splitterGap = 8;
        this.useSplitters = false;
        this.tbEdgeGap = tbEdgeGap;
        this.lrEdgeGap = lrEdgeGap;
        this.instanceName = instanceName;
        this.savedInfo = null;
        this.orientation = new Orientation(layoutVertically);
    }

    public static int[] decodeSizes(String encoding) throws IllegalArgumentException {
        String validChars = "|+.*pPrR";
        if (!PartitionLayout.checkSpec(encoding, validChars)) {
            return PartitionLayout.decodeFancySpec(encoding);
        }
        int sz = encoding.length();
        int[] decoded = new int[sz];
        for (int i = 0; i < sz; ++i) {
            decoded[i] = PartitionLayout.translateSpecificationChar(encoding.charAt(i));
        }
        return decoded;
    }

    static int[] decodeFancySpec(String encoding) throws IllegalArgumentException {
        StringTokenizer toks = new StringTokenizer(encoding, ",; ", false);
        int numToks = 0;
        while (toks.hasMoreTokens()) {
            toks.nextToken();
            ++numToks;
        }
        int[] decoded = new int[numToks];
        toks = new StringTokenizer(encoding, ",; ", false);
        int i = 0;
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            char c = tok.charAt(0);
            decoded[i] = Character.isDigit(c) ? Integer.parseInt(tok) : PartitionLayout.translateSpecificationChar(c);
            ++i;
        }
        return decoded;
    }

    static int translateSpecificationChar(char c) {
        switch (c) {
            case '*': 
            case '+': 
            case 'R': 
            case 'r': {
                return -1;
            }
            case '.': 
            case 'P': 
            case 'p': 
            case '|': {
                return -2;
            }
        }
        throw new IllegalArgumentException("unrecognized partition-spec character: '" + c + "'");
    }

    static boolean checkSpec(String tok, String validChars) {
        for (int i = tok.length() - 1; i >= 0; --i) {
            if (validChars.indexOf(tok.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean isVertical() {
        return this.layoutVertically;
    }

    public void setVertical(boolean vertical) {
        this.layoutVertically = vertical;
        this.orientation = new Orientation(vertical);
    }

    public void setPartitionSpecs(String encoding) {
        this.sectionSizes = PartitionLayout.decodeSizes(encoding);
    }

    public void setPartitionSpecs(int[] partitionSpecs) {
        this.sectionSizes = partitionSpecs;
    }

    public String getPartitionSpecs() {
        int n = this.getNumPartitions();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int spec = this.getPartitionSpec(i);
            switch (spec) {
                case -2: {
                    buf.append("P");
                    break;
                }
                case -1: {
                    buf.append("R");
                    break;
                }
                default: {
                    buf.append(spec);
                }
            }
            if (i >= n - 1) continue;
            buf.append(", ");
        }
        return new String(buf);
    }

    public int getPartitionSpec(int comp) {
        return this.sectionSizes[comp];
    }

    public int getTbEdgeGap() {
        return this.tbEdgeGap;
    }

    public void setTbEdgeGap(int tbEdgeGap) {
        this.tbEdgeGap = tbEdgeGap;
    }

    public int getLrEdgeGap() {
        return this.lrEdgeGap;
    }

    public void setLrEdgeGap(int lrEdgeGap) {
        this.lrEdgeGap = lrEdgeGap;
    }

    public int getSepGap() {
        return this.sepGap;
    }

    public void setSepGap(int sepGap) {
        this.sepGap = sepGap;
    }

    public int getSplitterGap() {
        return this.splitterGap;
    }

    public void setSplitterGap(int val) {
        this.splitterGap = val;
    }

    public int getNumPartitions() {
        return this.sectionSizes == null ? 0 : this.sectionSizes.length;
    }

    public boolean getUseSplitters() {
        return this.useSplitters;
    }

    public void setUseSplitters(boolean val) {
        this.useSplitters = val;
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    @Override
    public Dimension minimumLayoutSize(Container par) {
        return this.computeLayoutSize(par, true);
    }

    @Override
    public Dimension preferredLayoutSize(Container par) {
        return this.computeLayoutSize(par, false);
    }

    protected Dimension computeLayoutSize(Container par, boolean minSize) {
        int i;
        Insets insets = par.getInsets();
        int numComps = par.getComponentCount();
        int numSects = Math.min(numComps, this.sectionSizes.length);
        int[] rowHeights = new int[PartitionLayout.ceiling(numComps, numSects)];
        int[] colWidths = new int[numSects];
        if (this.savedInfo == null || this.savedInfo.length != numComps) {
            this.savedInfo = new Component[numComps];
        }
        Dimension[] subDims = new Dimension[numComps];
        for (int i2 = 0; i2 < numComps; ++i2) {
            int row = i2 / numSects;
            Component c = par.getComponent(i2);
            if (!c.isVisible()) continue;
            Dimension dim = minSize ? c.getMinimumSize() : c.getPreferredSize();
            subDims[i2] = dim = this.orientation.transform(dim);
            rowHeights[row] = Math.max(rowHeights[row], dim.height);
        }
        int totalHeight = 0;
        boolean haveVisibleRow = false;
        for (i = 0; i < rowHeights.length; ++i) {
            int rowHeight = rowHeights[i];
            if (rowHeight <= 0) continue;
            totalHeight += rowHeights[i];
            if (haveVisibleRow) {
                totalHeight += this.sepGap;
            }
            haveVisibleRow = true;
        }
        for (i = 0; i < numComps; ++i) {
            int col = i % numSects;
            Component c = par.getComponent(i);
            if (!c.isVisible()) continue;
            int sz = this.sectionSizes[col];
            int width = sz < 0 ? subDims[i].width : sz;
            colWidths[col] = Math.max(colWidths[col], width);
        }
        int totalWidth = 0;
        boolean haveFirstVisible = false;
        for (int i3 = 0; i3 < colWidths.length; ++i3) {
            if (colWidths[i3] <= 0) continue;
            totalWidth += colWidths[i3];
            if (haveFirstVisible) {
                totalWidth += this.sepGap;
            }
            haveFirstVisible = true;
        }
        if (this.useSplitters && this.splitterGap != this.sepGap) {
            totalWidth += this.adjustForSplitterGaps(par, numSects);
        }
        Dimension result = this.orientation.transform(new Dimension(totalWidth, totalHeight));
        result.width += this.lrEdgeGap * 2 + insets.left + insets.right;
        result.height += this.tbEdgeGap * 2 + insets.top + insets.bottom;
        return result;
    }

    @Override
    public void layoutContainer(Container par) {
        int i;
        int i2;
        int numSects;
        int numComps = par.getComponentCount();
        if (numComps < (numSects = Math.min(numComps, this.sectionSizes.length))) {
            System.out.println("ERROR: too few components in " + this.instanceName);
        }
        Dimension size = par.getSize();
        Insets insets = par.getInsets();
        int[] rowHeights = new int[PartitionLayout.ceiling(numComps, numSects)];
        int[] colWidths = new int[numSects];
        if (this.savedInfo == null || this.savedInfo.length != numComps) {
            this.savedInfo = new Component[numComps];
        }
        Dimension dims = this.orientation.transform(size);
        Insets margins = this.orientation.transform(new Insets(insets.top + this.tbEdgeGap, insets.left + this.lrEdgeGap, insets.bottom + this.tbEdgeGap, insets.right + this.lrEdgeGap));
        int xPos = margins.left;
        int yPos = margins.top;
        Dimension insideDimensions = new Dimension(dims.width - margins.left - margins.right, dims.height - margins.top - margins.bottom);
        int remainderHeight = insideDimensions.height;
        int remainderWidth = insideDimensions.width;
        int totalResizeable = 0;
        for (int i3 = 0; i3 < numSects; ++i3) {
            try {
                Component comp = par.getComponent(i3);
                if (!comp.isVisible() || this.getPartitionSpec(i3) != -1) continue;
                ++totalResizeable;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Error in " + this.instanceName + ": " + e);
                throw e;
            }
        }
        Dimension[] subDims = new Dimension[numComps];
        for (int i4 = 0; i4 < numComps; ++i4) {
            int row = i4 / numSects;
            Component comp = par.getComponent(i4);
            if (!comp.isVisible()) continue;
            Dimension dim = this.savedInfo[i4] == comp && comp.isValid() ? comp.getSize() : comp.getPreferredSize();
            subDims[i4] = dim = this.orientation.transform(dim);
            rowHeights[row] = Math.max(rowHeights[row], dim.height);
        }
        int totalHeight = 0;
        int numVisibleRows = 0;
        for (i2 = 0; i2 < rowHeights.length; ++i2) {
            int rowHeight = rowHeights[i2];
            if (rowHeight <= 0) continue;
            totalHeight += rowHeights[i2];
            if (numVisibleRows++ <= 0) continue;
            totalHeight += this.sepGap;
        }
        for (i2 = 0; i2 < rowHeights.length; ++i2) {
            float portion = (float)(remainderHeight * rowHeights[i2]) / (float)totalHeight;
            rowHeights[i2] = Math.max(1, Math.round(portion));
        }
        for (i2 = 0; i2 < numComps; ++i2) {
            int col = i2 % numSects;
            Component c = par.getComponent(i2);
            if (!c.isVisible()) continue;
            int width = subDims[i2].width;
            colWidths[col] = Math.max(colWidths[col], width);
        }
        int remainderComponentsCombinedWidth = 0;
        int numVisible = 0;
        Component prevComp = null;
        boolean prevResizeable = false;
        int numResizeable = 0;
        int numSplitters = 0;
        for (i = 0; i < numSects; ++i) {
            boolean resizeable;
            Component comp = par.getComponent(i);
            if (!comp.isVisible()) continue;
            boolean bl = resizeable = this.getPartitionSpec(i) == -1;
            if (resizeable) {
                ++numResizeable;
            }
            if (this.useSplitters) {
                if (resizeable && numResizeable < totalResizeable) {
                    ++numSplitters;
                }
                if (resizeable && !prevResizeable && numResizeable > 1) {
                    ++numSplitters;
                }
            }
            prevComp = comp;
            prevResizeable = resizeable;
            ++numVisible;
            if (this.sectionSizes[i] == -1) {
                remainderComponentsCombinedWidth += colWidths[i];
                continue;
            }
            if (this.sectionSizes[i] == -2) {
                remainderWidth -= colWidths[i];
                continue;
            }
            remainderWidth -= this.sectionSizes[i];
        }
        remainderWidth -= this.sepGap * Math.max(0, numVisible - 1);
        remainderWidth -= numSplitters * (this.splitterGap - this.sepGap);
        prevComp = null;
        numResizeable = 0;
        prevResizeable = false;
        for (i = 0; i < numComps; ++i) {
            int width;
            boolean resizeable;
            int col = i % numSects;
            Component comp = par.getComponent(i);
            if (!comp.isVisible()) {
                this.savedInfo[i] = null;
                continue;
            }
            boolean bl = resizeable = this.getPartitionSpec(col) == -1;
            if (resizeable) {
                ++numResizeable;
            }
            if (this.useSplitters && resizeable && !prevResizeable && numResizeable > 1) {
                xPos += this.splitterGap - this.sepGap;
            }
            int compWidth = width = this.sectionSizes[col];
            int preferredColumnWidth = colWidths[col];
            Component component = this.savedInfo[i] = comp.isShowing() && comp.isValid() ? comp : null;
            if (width == -1) {
                width = remainderComponentsCombinedWidth == 0 ? Math.max(50, preferredColumnWidth) : remainderWidth * preferredColumnWidth / remainderComponentsCombinedWidth;
                compWidth = width;
            } else if (width == -2) {
                width = preferredColumnWidth;
                compWidth = subDims[i].width;
            }
            Rectangle r = this.orientation.transform(new Rectangle(xPos, yPos, compWidth, rowHeights[i / numSects]));
            if (!r.equals(comp.getBounds())) {
                comp.setBounds(r.x, r.y, r.width, r.height);
            }
            int gap = this.sepGap;
            if (this.useSplitters && resizeable && numResizeable < totalResizeable) {
                gap = this.splitterGap;
            }
            prevComp = comp;
            prevResizeable = resizeable;
            xPos += width + gap;
            if ((i + 1) % numSects != 0) continue;
            prevResizeable = false;
            numResizeable = 0;
            prevComp = null;
            yPos += rowHeights[i / numSects] + this.sepGap;
            xPos = margins.left;
        }
    }

    int adjustForSplitterGaps(Container par, int numSects) {
        int numSplitters = 0;
        int totalResizeable = 0;
        for (int i = 0; i < numSects; ++i) {
            Component comp = par.getComponent(i);
            if (!comp.isVisible() || this.getPartitionSpec(i) != -1) continue;
            ++totalResizeable;
        }
        Component prevComp = null;
        boolean prevResizeable = false;
        int numResizeable = 0;
        for (int i = 0; i < numSects; ++i) {
            boolean resizeable;
            Component comp = par.getComponent(i);
            if (!comp.isVisible()) continue;
            boolean bl = resizeable = this.getPartitionSpec(i) == -1;
            if (resizeable) {
                ++numResizeable;
            }
            if (resizeable && numResizeable < totalResizeable) {
                ++numSplitters;
            }
            if (resizeable && !prevResizeable && numResizeable > 1) {
                ++numSplitters;
            }
            prevComp = comp;
            prevResizeable = resizeable;
        }
        int adjustment = numSplitters * (this.splitterGap - this.sepGap);
        return adjustment;
    }

    static final int ceiling(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        int quot = a / b;
        int rem = a % b;
        return quot + (rem == 0 ? 0 : 1);
    }
}

