/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modelobjects.util.XmlWritable;

public abstract class AnnotatedObject
extends XmlWritable {
    protected String descriptionTagName = "Description";
    protected String propertyTagName = "Property";
    protected String description;
    protected HashMap properties;

    protected AnnotatedObject() {
        this("?");
    }

    protected AnnotatedObject(String xmlElementName) {
        super(xmlElementName);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public Object getProperty(String propertyName, Object defaultValue) {
        Object result = this.properties == null ? null : (Object)this.properties.get(propertyName);
        return result != null ? result : defaultValue;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if (propertyValue == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, propertyValue);
        }
    }

    public void removeProperty(String propertyName) {
        if (this.properties != null) {
            this.properties.remove(propertyName);
        }
    }

    public Set getPropertyNames() {
        return this.properties == null ? Collections.EMPTY_SET : this.properties.keySet();
    }

    @Override
    public List getChildren() {
        ArrayList<XmlWritable> list = new ArrayList<XmlWritable>();
        if (this.description != null) {
            list.add(AnnotatedObject.makePCDataElement(this.descriptionTagName, this.description, true));
        }
        for (String name : this.getPropertyNames()) {
            Object val = this.properties.get(name);
            list.add(new NamedProperty(this.propertyTagName, name, val));
        }
        return list;
    }

    public String getDescriptionTagName() {
        return this.descriptionTagName;
    }

    public void setDescriptionTagName(String descriptionTagName) {
        this.descriptionTagName = descriptionTagName;
    }

    public String getPropertyTagName() {
        return this.propertyTagName;
    }

    public void setPropertyTagName(String propertyTagName) {
        this.propertyTagName = propertyTagName;
    }

    public static class NamedProperty
    extends XmlWritable {
        private String propertyName;
        private Object propertyValue;

        public NamedProperty(String xmlElementName, String propertyName, Object propertyValue) {
            super(xmlElementName);
            if (propertyName == null) {
                throw new IllegalArgumentException("null propertyName");
            }
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Object getPropertyValue() {
            return this.propertyValue;
        }

        @Override
        public Map getAttributes() {
            Map attrs = super.getAttributes();
            String val = this.propertyValue == null ? "null" : this.propertyValue.toString();
            attrs.put("name", this.propertyName);
            attrs.put("value", val);
            return attrs;
        }

        @Override
        public List getChildren() {
            return Collections.EMPTY_LIST;
        }
    }
}

