/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

public abstract class CommonEventSupport
implements Serializable {
    private Object eventSource;
    private transient Vector listeners;
    private static final Class[] noExpectedExceptions = new Class[0];

    protected CommonEventSupport() {
        this(null);
    }

    protected CommonEventSupport(Object eventSource) {
        this.eventSource = eventSource;
        this.listeners = null;
    }

    protected Object getEventSource() {
        return this.eventSource;
    }

    public boolean anyListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    protected synchronized void addEventListener(EventListener listener) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(listener)) {
            v.addElement(listener);
            this.listeners = v;
        }
    }

    protected synchronized void removeEventListener(EventListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(listener);
            this.listeners = v;
        }
    }

    protected void fireEvent(Class listenerInterface, String listenerMethodName, EventObject evt) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        try {
            this.fireEvent(listenerInterface, listenerMethodName, evt, noExpectedExceptions);
        }
        catch (Throwable e) {
            System.err.println("Error in EventListener method " + listenerMethodName + ": " + e);
        }
    }

    protected void fireEvent(Class listenerInterface, String listenerMethodName, EventObject evt, Class expectedExceptionClass) throws Throwable {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        this.fireEvent(listenerInterface, listenerMethodName, evt, new Class[]{expectedExceptionClass});
    }

    protected void fireEvent(Class listenerInterface, String listenerMethodName, EventObject evt, Class[] expectedExceptionClasses) throws Throwable {
        Method listenerMethod;
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        try {
            Class[] paramTypes = new Class[]{evt.getClass()};
            listenerMethod = this.lookupMethod(listenerInterface, listenerMethodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            System.err.println("No such method: " + listenerInterface.getName() + "." + listenerMethodName + ": " + e.getMessage());
            return;
        }
        try {
            this.fireEvent(listenerMethod, evt, expectedExceptionClasses);
        }
        catch (Exception e) {
            for (int i = 0; i < expectedExceptionClasses.length; ++i) {
                if (!expectedExceptionClasses[i].isInstance(e)) continue;
                throw e;
            }
            System.err.println("Error in EventListener method " + listenerInterface.getName() + "." + listenerMethodName + ": " + e);
        }
    }

    protected Method lookupMethod(Class listenerInterface, String listenerMethodName, Class[] paramTypes) throws NoSuchMethodException {
        Method m = (Method)MethodCacheLazyHolder.METHOD_CACHE.get(listenerMethodName);
        if (m == null || m.getDeclaringClass() != listenerInterface) {
            m = listenerInterface.getMethod(listenerMethodName, paramTypes);
            MethodCacheLazyHolder.METHOD_CACHE.put(listenerMethodName, m);
        }
        return m;
    }

    protected void fireEvent(Method listenerMethod, EventObject evt, Class[] expectedExceptionClasses) throws Throwable {
        Vector listeners = this.listeners;
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Object[] args = new Object[]{evt};
        ReflectiveOperationException e = null;
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                listenerMethod.invoke(listeners.elementAt(i), args);
            }
            catch (IllegalAccessException e1) {
                e = e1;
            }
            catch (InvocationTargetException e2) {
                Throwable targetException = e2.getTargetException();
                for (int j = 0; j < expectedExceptionClasses.length; ++j) {
                    if (!expectedExceptionClasses[j].isInstance(targetException)) continue;
                    throw targetException;
                }
                e = e2;
                System.err.println("Event in EventListener method " + listenerMethod.getName() + ": " + targetException.getMessage());
                targetException.printStackTrace(System.err);
            }
            catch (RuntimeException bug) {
                System.err.println("Error in EventListener method " + listenerMethod.getName() + ": " + bug);
                return;
            }
            if (e == null) continue;
            System.err.println("Event listener error in method " + listenerMethod.getName() + ": " + e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Vector listeners = null;
        CommonEventSupport commonEventSupport = this;
        synchronized (commonEventSupport) {
            if (this.listeners != null) {
                listeners = (Vector)this.listeners.clone();
            }
        }
        int num = listeners == null ? 0 : listeners.size();
        for (int i = 0; i < num; ++i) {
            Object listener = listeners.elementAt(i);
            if (!(listener instanceof Serializable)) continue;
            stream.writeObject(listener);
        }
        stream.writeObject(null);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Object listener;
        stream.defaultReadObject();
        while ((listener = stream.readObject()) != null) {
            if (this.listeners == null) {
                this.listeners = new Vector(2);
            }
            this.listeners.addElement(listener);
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder(this.getClass().getName());
        sBuilder.append(" ( ");
        sBuilder.append("Event Source : ").append(this.eventSource).append(" ; ");
        sBuilder.append("Listeners : ").append(this.listeners);
        sBuilder.append(" )");
        return sBuilder.toString();
    }

    private static class MethodCacheLazyHolder {
        private static final Hashtable METHOD_CACHE = new Hashtable();

        private MethodCacheLazyHolder() {
        }
    }
}

