/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class CompoundComparator
implements Comparator,
Serializable {
    private Comparator[] subComparators;
    private int numSubs;

    public CompoundComparator(Comparator c1, Comparator c2) {
        this(new Comparator[]{c1, c2});
    }

    public CompoundComparator(Comparator[] subComparators) {
        this.subComparators = subComparators;
        this.numSubs = subComparators == null ? 0 : subComparators.length;
    }

    public int compare(Object a, Object b) {
        for (int i = 0; i < this.numSubs; ++i) {
            int cmp = this.subComparators[i].compare(a, b);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CompoundComparator that = (CompoundComparator)obj;
        if (this.numSubs != that.numSubs) {
            return false;
        }
        for (int i = 0; i < this.numSubs; ++i) {
            if (this.subComparators[i].equals(that.subComparators[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.subComparators);
    }
}

