/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import modelobjects.util.EnumValue;

public class EnumGroup {
    private String enumGroupName;
    private HashMap instanceMap;
    private EnumValue defaultValue;
    private boolean sealed;
    private EnumGroup parentGroup;
    private transient Constructor enumValueCtor;
    private transient boolean constructSubclassInstance = true;
    private static HashMap ENUM_GROUP_EXTENT = new HashMap();

    public EnumGroup(String enumGroupName) {
        this(enumGroupName, false);
    }

    public EnumGroup(String enumGroupName, boolean sealed) {
        this(enumGroupName, null, sealed);
    }

    public EnumGroup(String enumGroupName, EnumGroup parentGroup, boolean sealed) {
        if (EnumGroup.getEnumGroup(enumGroupName) != null) {
            throw new IllegalStateException("duplicate EnumGroup name: " + enumGroupName);
        }
        this.enumGroupName = enumGroupName;
        this.parentGroup = parentGroup;
        this.sealed = sealed;
        this.instanceMap = new HashMap();
        ENUM_GROUP_EXTENT.put(enumGroupName, this);
    }

    void recordEnumValue(EnumValue val) {
        this.recordEnumValue(val, true, true);
    }

    void recordEnumValue(EnumValue val, boolean byName, boolean byCode) {
        if (byName) {
            this.instanceMap.put(val.getName(), val);
        }
        if (byCode) {
            this.instanceMap.put(new Integer(val.getCode()), val);
        }
    }

    public String getEnumGroupName() {
        return this.enumGroupName;
    }

    public EnumValue getByCode(int code) {
        EnumValue result = (EnumValue)this.instanceMap.get(new Integer(code));
        if (result != null || this.parentGroup == null) {
            return result;
        }
        return this.parentGroup.getByCode(code);
    }

    public EnumValue getByName(String name) {
        EnumValue result = (EnumValue)this.instanceMap.get(name);
        if (result != null || this.parentGroup == null) {
            return result;
        }
        return this.parentGroup.getByName(name);
    }

    protected EnumValue makeEnumValue(String name, int code) {
        if (this.isSealed()) {
            return null;
        }
        if (this.constructSubclassInstance) {
            try {
                if (this.enumValueCtor == null) {
                    Class<?> enumValueSubclass = Class.forName(this.enumGroupName);
                    Class[] ctorParams = new Class[]{Integer.TYPE, String.class};
                    this.enumValueCtor = enumValueSubclass.getConstructor(ctorParams);
                }
                Object[] ctorArgs = new Object[]{new Integer(code), name};
                return (EnumValue)this.enumValueCtor.newInstance(ctorArgs);
            }
            catch (Exception e) {
                System.err.println("Unable to make instance of " + this.enumGroupName + ": " + e);
                this.constructSubclassInstance = false;
            }
        }
        return new EnumValue(this, code, name);
    }

    public EnumValue findOrCreateEnumValue(String name, int code) {
        EnumValue value = this.getByName(name);
        if (value == null || value.getCode() != code) {
            value = this.makeEnumValue(name, code);
        }
        return value;
    }

    public Set getValues() {
        Set result = this.parentGroup != null ? this.parentGroup.getValues() : new HashSet();
        result.addAll(this.instanceMap.values());
        return result;
    }

    public static EnumGroup getEnumGroup(String enumGroupName) {
        return EnumGroup.getEnumGroup(enumGroupName, false);
    }

    public static EnumGroup getEnumGroup(String enumGroupName, boolean createIfNeeded) {
        EnumGroup group = (EnumGroup)ENUM_GROUP_EXTENT.get(enumGroupName);
        if (group == null && createIfNeeded) {
            group = new EnumGroup(enumGroupName);
        }
        return group;
    }

    public EnumValue getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(EnumValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }

    public String toString() {
        String parentGroupPart = this.parentGroup == null ? "" : " parentGroup=" + this.parentGroup.enumGroupName;
        return "<EnumGroup " + this.enumGroupName + parentGroupPart + ">";
    }
}

