/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import modelobjects.util.EnumGroup;

public class EnumValue
implements Serializable,
Comparable {
    static final long serialVersionUID = -7751142842063816257L;
    private String groupName;
    private transient EnumGroup group;
    private int code;
    private String name;

    public EnumValue(EnumGroup enumGroup, int code, String name) {
        this.group = enumGroup;
        this.groupName = enumGroup.getEnumGroupName();
        this.code = code;
        this.name = name;
        enumGroup.recordEnumValue(this);
    }

    public EnumGroup getGroup() {
        if (this.group == null && this.groupName != null) {
            this.group = EnumGroup.getEnumGroup(this.groupName);
        }
        return this.group;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.code;
    }

    public int compareTo(Object other) {
        EnumValue that = (EnumValue)other;
        int result = this.code - that.code;
        if (result != 0) {
            return result;
        }
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EnumValue that = (EnumValue)obj;
        return this.group == that.group && this.code == that.code && this.name.equals(that.name);
    }

    public String toString() {
        int lastDot = this.groupName.lastIndexOf(46);
        String group = lastDot == -1 ? this.groupName : this.groupName.substring(lastDot + 1);
        return group + ":" + this.name + "=" + this.code;
    }

    public EnumValue getRecordedEnumValue() {
        EnumValue localValue;
        EnumGroup enumGroup = EnumGroup.getEnumGroup(this.groupName);
        if (enumGroup == null) {
            enumGroup = new EnumGroup(this.groupName);
        }
        return (localValue = enumGroup.findOrCreateEnumValue(this.name, this.code)) != null ? localValue : enumGroup.getDefaultValue();
    }

    protected boolean neutralizeSubclassInstancesOnDeserialization() {
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.getClass() == EnumValue.class) {
            return this.getRecordedEnumValue();
        }
        if (this.neutralizeSubclassInstancesOnDeserialization()) {
            return new EnumValue(this.getGroup(), this.code, this.name);
        }
        EnumValue replacement = this.getRecordedEnumValue();
        return replacement != null ? replacement : this;
    }

    public EnumValue makeDerivedValue(String derivedValueName) {
        EnumGroup enumGroup = this.getGroup();
        EnumValue derivedValue = enumGroup.findOrCreateEnumValue(derivedValueName, this.code);
        return derivedValue;
    }
}

