/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;

public class EnumeratedTypePropertyEditor
extends PropertyEditorSupport
implements ItemListener {
    private JComboBox comboBox;
    private String propertyName;
    private List viewValues;
    private List modelValues;

    public EnumeratedTypePropertyEditor() {
        this("", new ArrayList(), new ArrayList());
    }

    public EnumeratedTypePropertyEditor(String propertyName, HashMap viewToModelMap) {
        this(propertyName, new ArrayList(viewToModelMap.size()), new ArrayList(viewToModelMap.size()));
        for (String viewValue : viewToModelMap.keySet()) {
            Object modelValue = viewToModelMap.get(viewValue);
            this.addViewAndModelPair(viewValue, modelValue);
        }
    }

    public EnumeratedTypePropertyEditor(String propertyName, String[] viewValues, Object[] modelValues) {
        this(propertyName, EnumeratedTypePropertyEditor.makeList(viewValues), EnumeratedTypePropertyEditor.makeList(modelValues));
    }

    public EnumeratedTypePropertyEditor(String propertyName, List viewValues, List modelValues) {
        this.propertyName = propertyName;
        this.viewValues = viewValues;
        this.modelValues = modelValues;
        if (viewValues.size() != modelValues.size()) {
            throw new IllegalArgumentException("view and model value lists must have the same length");
        }
        Object[] keyVals = viewValues.toArray();
        this.comboBox = new JComboBox<Object>(keyVals);
        this.comboBox.addItemListener(this);
    }

    public final void addViewAndModelPair(String viewValue, Object modelValue) {
        this.viewValues.add(viewValue);
        this.modelValues.add(modelValue);
        this.comboBox.addItem(viewValue);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.comboBox;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.comboBox.setSelectedItem("");
        } else {
            int index = this.modelValues.indexOf(value);
            if (index == -1) {
                this.comboBox.setSelectedItem("");
            } else {
                this.comboBox.setSelectedItem(this.viewValues.get(index));
            }
        }
    }

    @Override
    public void setAsText(String stringValue) {
        this.comboBox.setSelectedItem(stringValue);
    }

    @Override
    public Object getValue() {
        String viewValue = this.getAsText();
        if (viewValue == null) {
            return null;
        }
        int index = this.viewValues.indexOf(viewValue);
        return index == -1 ? null : this.modelValues.get(index);
    }

    @Override
    public String getAsText() {
        String currentViewValue = (String)this.comboBox.getSelectedItem();
        return currentViewValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.firePropertyChange();
    }

    private static List makeList(Object[] values) {
        int num = values.length;
        ArrayList<Object> result = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            result.add(values[i]);
        }
        return result;
    }
}

