/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExtensionsClassLoader
extends ClassLoader {
    private static final char SEPCHAR = File.separatorChar;
    private ClassLoader parent;
    private int pathLength;
    private File[] absFiles;
    private Object[] pathEntries;

    public ExtensionsClassLoader(File[] classPathFiles) throws IOException {
        this(classPathFiles, ClassLoader.getSystemClassLoader());
    }

    public ExtensionsClassLoader(File[] classPathFiles, ClassLoader parentClassLoader) throws IOException {
        super(parentClassLoader);
        this.parent = parentClassLoader;
        this.pathLength = classPathFiles.length;
        this.pathEntries = new ZipFile[this.pathLength];
        this.absFiles = new File[this.pathLength];
        for (int i = 0; i < this.pathLength; ++i) {
            File pathEntryFile;
            this.absFiles[i] = pathEntryFile = classPathFiles[i].getAbsoluteFile();
            this.pathEntries[i] = pathEntryFile.isDirectory() ? pathEntryFile : new ZipFile(pathEntryFile);
        }
    }

    @Override
    protected URL findResource(String resourceName) {
        for (int i = 0; i < this.pathLength; ++i) {
            Object pathEntry = this.pathEntries[i];
            if (pathEntry instanceof ZipFile) {
                ZipFile zipFile = (ZipFile)pathEntry;
                ZipEntry zipEntry = zipFile.getEntry(resourceName);
                if (zipEntry == null) continue;
                try {
                    String zipFileUrlString = this.absFiles[i].toURL().toExternalForm();
                    return new URL("jar:" + zipFileUrlString + "!" + resourceName);
                }
                catch (MalformedURLException badURL) {
                    return null;
                }
            }
            File directory = (File)pathEntry;
            File dirEntry = new File(directory, resourceName.replace('/', File.separatorChar));
            if (!dirEntry.exists()) continue;
            try {
                return dirEntry.toURL();
            }
            catch (MalformedURLException badURL) {
                return null;
            }
        }
        return super.findResource(resourceName);
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        String convertedClassName = className.replace('.', '/') + ".class";
        byte[] classBytes = this.findClassBytes(convertedClassName);
        if (classBytes != null) {
            return this.defineClass(className, classBytes, 0, classBytes.length);
        }
        return super.findClass(className);
    }

    private byte[] findClassBytes(String className) {
        for (int i = 0; i < this.pathLength; ++i) {
            Object pathEntry = this.pathEntries[i];
            if (pathEntry instanceof ZipFile) {
                ZipFile zipFile = (ZipFile)pathEntry;
                ZipEntry zipEntry = zipFile.getEntry(className);
                if (zipEntry == null) continue;
                try {
                    return this.getZipEntryBytes(zipFile, zipEntry);
                }
                catch (IOException ioe) {
                    break;
                }
            }
            File directory = (File)pathEntry;
            File dirEntry = new File(directory, className.replace('/', SEPCHAR));
            if (!dirEntry.exists()) continue;
            try {
                return this.getClassFileBytes(dirEntry);
            }
            catch (IOException ioe) {
                break;
            }
        }
        return null;
    }

    private byte[] getZipEntryBytes(ZipFile zipFile, ZipEntry classFileZipEntry) throws IOException {
        int num;
        long size = classFileZipEntry.getSize();
        byte[] result = new byte[(int)size];
        InputStream inStream = zipFile.getInputStream(classFileZipEntry);
        for (long bytesRead = 0L; bytesRead < size; bytesRead += (long)num) {
            num = inStream.read(result, (int)bytesRead, (int)(size - bytesRead));
        }
        inStream.close();
        return result;
    }

    private byte[] getClassFileBytes(File classFile) throws IOException {
        int num;
        long size = classFile.length();
        byte[] result = new byte[(int)size];
        FileInputStream inStream = new FileInputStream(classFile);
        for (long bytesRead = 0L; bytesRead < size; bytesRead += (long)num) {
            num = ((InputStream)inStream).read(result, (int)bytesRead, (int)(size - bytesRead));
        }
        ((InputStream)inStream).close();
        return result;
    }

    public static void main(String[] args) {
        try {
            File[] classPathFiles = new File[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                classPathFiles[i - 1] = new File(args[i]);
            }
            ExtensionsClassLoader loader = new ExtensionsClassLoader(classPathFiles);
            Class<?> cl = loader.loadClass(args[0]);
            System.out.println("cl = " + cl);
            Object obj = cl.newInstance();
            System.out.println("obj = " + obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

