/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

public class FindClass {
    public static Class forName(String className) throws ClassNotFoundException {
        return FindClass.forName(className, true, FindClass.class.getClassLoader());
    }

    public static Class forName(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.endsWith("[]")) {
            String base = className.substring(0, className.length() - 2).trim();
            return FindClass.findArrayType(base, initialize, classLoader);
        }
        if (className.indexOf(46) == -1) {
            if (className.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (className.equals("int")) {
                return Integer.TYPE;
            }
            if (className.equals("char")) {
                return Character.TYPE;
            }
            if (className.equals("byte")) {
                return Byte.TYPE;
            }
            if (className.equals("short")) {
                return Short.TYPE;
            }
            if (className.equals("long")) {
                return Long.TYPE;
            }
            if (className.equals("float")) {
                return Float.TYPE;
            }
            if (className.equals("double")) {
                return Double.TYPE;
            }
            if (className.equals("void")) {
                return Void.TYPE;
            }
        }
        return Class.forName(className, initialize, classLoader);
    }

    public static String getName(Class cl, boolean trimPackage) {
        int lastDot;
        String name = cl.getName();
        int arrayCount = 0;
        while (name.startsWith("[")) {
            name = name.substring(1);
            ++arrayCount;
        }
        if (arrayCount > 0) {
            switch (name.charAt(0)) {
                case 'Z': {
                    name = "boolean";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'L': {
                    name = name.substring(1, name.length() - 1).replace('/', '.');
                }
            }
            for (int i = 0; i < arrayCount; ++i) {
                name = name + "[]";
            }
        }
        if (trimPackage && (lastDot = name.lastIndexOf(46)) != -1) {
            name = name.substring(lastDot + 1);
        }
        return name;
    }

    private static Class findArrayType(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        className = className.indexOf(46) == -1 ? (className.equals("char") ? "[C" : (className.equals("boolean") ? "[Z" : (className.equals("int") ? "[I" : (className.equals("byte") ? "[B" : (className.equals("short") ? "[S" : (className.equals("long") ? "[J" : (className.equals("float") ? "[F" : (className.equals("double") ? "[D" : (className.equals("void") ? "[V" : "[L" + className + ";"))))))))) : "[L" + className + ";";
        return Class.forName(className, initialize, classLoader);
    }

    private FindClass() {
    }
}

