/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import modelobjects.util.IndexedSet;
import modelobjects.util.ResortableSortedSet;

public class IndexedSortedSet
extends AbstractSet
implements SortedSet,
IndexedSet,
ResortableSortedSet,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int DEFAULT_MINIMUM_CAPACITY = 4;
    private ArrayList arrayList;
    private Comparator comparator;

    public IndexedSortedSet() {
        this(null, 8);
    }

    public IndexedSortedSet(Comparator comparator) {
        this(comparator, 8);
    }

    public IndexedSortedSet(int initialCapacity) {
        this(null, initialCapacity);
    }

    public IndexedSortedSet(Collection aColl) {
        this(null, Math.max(aColl.size(), 4));
        this.addColletions(aColl);
    }

    public IndexedSortedSet(Comparator comparator, Collection aColl) {
        this(comparator, Math.max(aColl.size(), 4));
        this.addColletions(aColl);
    }

    private void addColletions(Collection aColl) {
        this.addAll(aColl);
    }

    public IndexedSortedSet(Comparator comparator, int initialCapacity) {
        this.arrayList = new ArrayList(initialCapacity);
        this.comparator = comparator;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    @Override
    public void sortBy(Comparator c) {
        Object[] elems = this.arrayList.toArray();
        Arrays.sort(elems, c);
        this.comparator = c;
        this.arrayList.clear();
        int n = elems.length;
        for (int i = 0; i < n; ++i) {
            this.arrayList.add(elems[i]);
        }
    }

    @Override
    public int size() {
        return this.arrayList.size();
    }

    @Override
    public Iterator iterator() {
        return this.arrayList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.arrayList.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.arrayList.toArray(a);
    }

    @Override
    public void clear() {
        this.arrayList.clear();
    }

    @Override
    public boolean add(Object obj) {
        int index = this.binarySearch(obj);
        if (index < 0) {
            int insertPos = -1 - index;
            this.arrayList.add(insertPos, obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.binarySearch(obj);
        if (index >= 0) {
            this.arrayList.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public int addElement(Object obj) {
        int index = this.binarySearch(obj);
        if (index < 0) {
            int insertPos = -1 - index;
            this.arrayList.add(insertPos, obj);
            return insertPos;
        }
        return -1;
    }

    @Override
    public int removeElement(Object obj) {
        int index = this.binarySearch(obj);
        if (index < 0) {
            int pos = -1 - index;
            this.arrayList.remove(pos);
            return pos;
        }
        return -1;
    }

    @Override
    public Object removeElementAt(int index) {
        Object oldVal = this.getElementAt(index);
        this.arrayList.remove(index);
        return oldVal;
    }

    public Object first() {
        return this.arrayList.get(0);
    }

    public Object last() {
        return this.arrayList.get(this.arrayList.size() - 1);
    }

    @Override
    public int indexOf(Object obj) {
        int index = this.binarySearch(obj);
        return index < 0 ? -1 : index;
    }

    public int indexFrom(Object obj) {
        int index = this.binarySearch(obj);
        return index < 0 ? -1 - index : index;
    }

    @Override
    public Object getElementAt(int index) {
        return this.arrayList.get(index);
    }

    public SortedSet subSet(Object fromElem, Object toElem) {
        if (fromElem == null || toElem == null) {
            throw new NullPointerException();
        }
        if (this.compare(fromElem, toElem) > 0) {
            throw new IllegalArgumentException("fromElem > toElem");
        }
        return new SubSet(this, fromElem, toElem);
    }

    public SortedSet headSet(Object toElem) {
        if (toElem == null) {
            throw new NullPointerException();
        }
        return new SubSet(this, null, toElem);
    }

    public SortedSet tailSet(Object fromElem) {
        if (fromElem == null) {
            throw new NullPointerException();
        }
        return new SubSet(this, fromElem, null);
    }

    protected int binarySearch(Object obj) {
        int lo = 0;
        int hi = this.arrayList.size() - 1;
        while (hi >= lo) {
            int mid = (lo + hi) / 2;
            int cmp = this.compare(obj, this.arrayList.get(mid));
            if (cmp > 0) {
                lo = mid + 1;
                continue;
            }
            if (cmp < 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -1 - lo;
    }

    protected int compare(Object obj1, Object obj2) {
        if (this.comparator != null) {
            return this.comparator.compare(obj1, obj2);
        }
        return ((Comparable)obj1).compareTo(obj2);
    }

    public static void main(String[] args) {
        Comparator Reverse = new Comparator(){

            public int compare(Object o1, Object o2) {
                return -((Comparable)o1).compareTo(o2);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
        IndexedSortedSet s = new IndexedSortedSet();
        s.add("this");
        s.add("is");
        s.add("a");
        s.add("zebra");
        s.add("test");
        s.add("of");
        s.add("IndexedSortedSet");
        System.out.println(s);
        System.out.println(s.subSet("a", "z"));
        System.out.println(s.subSet("a", "zebra"));
        System.out.println("indexOf(of) = " + s.indexOf("of"));
        System.out.println("indexOf(foo) = " + s.indexOf("foo"));
        System.out.println(s.headSet("test"));
        System.out.println(s.tailSet("test"));
        System.out.println("Reversing...");
        s.sortBy(Reverse);
        System.out.println(s);
        System.out.println(s.subSet("zebra", "a"));
    }

    static class SubsetIterator
    implements Iterator,
    Serializable {
        private IndexedSortedSet parent;
        private Object loBound;
        private Object hiBound;
        private static final Object NO_NEXT_VALUE = new Object();
        private Iterator iter;
        private Object nextElem;

        SubsetIterator(IndexedSortedSet parent, Object loBound, Object hiBound) {
            this.parent = parent;
            this.loBound = loBound;
            this.hiBound = hiBound;
            this.iter = parent.iterator();
            this.advanceToFirst();
        }

        @Override
        public boolean hasNext() {
            return this.nextElem != NO_NEXT_VALUE;
        }

        public Object next() {
            if (this.nextElem == NO_NEXT_VALUE) {
                throw new NoSuchElementException();
            }
            Object result = this.nextElem;
            this.advanceToNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceToFirst() {
            this.nextElem = NO_NEXT_VALUE;
            while (this.iter.hasNext()) {
                this.nextElem = this.iter.next();
                if (this.loBound != null && this.parent.compare(this.nextElem, this.loBound) < 0) continue;
                break;
            }
        }

        private void advanceToNext() {
            this.nextElem = NO_NEXT_VALUE;
            if (this.iter.hasNext()) {
                Object elem = this.iter.next();
                if (this.hiBound == null || this.parent.compare(elem, this.hiBound) < 0) {
                    this.nextElem = elem;
                }
            }
        }
    }

    static class SubSet
    extends AbstractSet
    implements SortedSet,
    Serializable {
        private IndexedSortedSet parent;
        private Object loBound;
        private Object hiBound;

        SubSet(IndexedSortedSet parent, Object loBound, Object hiBound) {
            this.parent = parent;
            this.loBound = loBound;
            this.hiBound = hiBound;
        }

        @Override
        public int size() {
            int lo = this.loBound == null ? 0 : this.parent.indexFrom(this.loBound);
            int hi = this.hiBound == null ? this.parent.size() : this.parent.indexFrom(this.hiBound);
            return hi - lo;
        }

        @Override
        public Iterator iterator() {
            return new SubsetIterator(this.parent, this.loBound, this.hiBound);
        }

        public Comparator comparator() {
            return this.parent.comparator();
        }

        public Object first() {
            int pos;
            int n = pos = this.loBound == null ? 0 : this.parent.indexFrom(this.loBound);
            if (pos >= this.parent.size()) {
                throw new NoSuchElementException();
            }
            return this.parent.getElementAt(pos);
        }

        public Object last() {
            int pos;
            int n = pos = this.hiBound == null ? this.parent.size() - 1 : this.parent.indexFrom(this.hiBound) - 1;
            if (pos >= this.parent.size()) {
                throw new NoSuchElementException();
            }
            return this.parent.getElementAt(pos);
        }

        public SortedSet subSet(Object fromElem, Object toElem) {
            if (fromElem == null || toElem == null) {
                throw new NullPointerException();
            }
            if (this.loBound != null && this.parent.compare(this.loBound, fromElem) < 0) {
                fromElem = this.loBound;
            }
            if (this.hiBound != null && this.parent.compare(this.hiBound, toElem) > 0) {
                toElem = this.hiBound;
            }
            return this.parent.subSet(fromElem, toElem);
        }

        public SortedSet headSet(Object toElem) {
            if (toElem == null) {
                throw new NullPointerException();
            }
            if (this.hiBound != null && this.parent.compare(this.hiBound, toElem) > 0) {
                toElem = this.hiBound;
            }
            return this.parent.headSet(toElem);
        }

        public SortedSet tailSet(Object fromElem) {
            if (fromElem == null) {
                throw new NullPointerException();
            }
            if (this.loBound != null && this.parent.compare(this.loBound, fromElem) < 0) {
                fromElem = this.loBound;
            }
            return this.parent.tailSet(fromElem);
        }
    }
}

