/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

public class LightweightEventSupport {
    private Object owner;
    private transient Vector listeners;

    public LightweightEventSupport() {
        this(null);
    }

    public LightweightEventSupport(Object owner) {
        this.owner = owner;
        this.listeners = null;
    }

    public boolean anyListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public int getNumListeners() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void addEventListener(EventListener listener) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(listener)) {
            v.addElement(listener);
            this.listeners = v;
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(listener);
            this.listeners = v;
        }
    }

    public void fireEvent(Class listenerInterface, String listenerMethodName, EventObject evt) {
        Vector listeners = this.listeners;
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Class[] paramTypes = new Class[]{evt.getClass()};
        try {
            Method listenerMethod = this.lookupMethod(listenerInterface, listenerMethodName, paramTypes);
            this.fireEvent(listeners, listenerMethod, evt);
        }
        catch (NoSuchMethodException noSuchMethod) {
            noSuchMethod.printStackTrace();
        }
    }

    private Method lookupMethod(Class listenerInterface, String listenerMethodName, Class[] paramTypes) throws NoSuchMethodException {
        Method m = (Method)HashtableLazyHolder.METHOD_CACHE.get(listenerMethodName);
        if (m == null || m.getDeclaringClass() != listenerInterface) {
            m = listenerInterface.getMethod(listenerMethodName, paramTypes);
            HashtableLazyHolder.METHOD_CACHE.put(listenerMethodName, m);
        }
        return m;
    }

    private void fireEvent(Vector listeners, Method listenerMethod, EventObject evt) {
        Object[] args = new Object[]{evt};
        int n = listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                listenerMethod.invoke(listeners.elementAt(i), args);
                continue;
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e2) {
                e2.getTargetException().printStackTrace();
            }
        }
    }

    private static class HashtableLazyHolder {
        private static final Hashtable METHOD_CACHE = new Hashtable();

        private HashtableLazyHolder() {
        }
    }
}

