/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyEditorSupport;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NumberPropertyEditor
extends PropertyEditorSupport
implements DocumentListener {
    private JTextField textField;
    private String propertyName;
    private Class requiredType;
    private Number minValue;
    private Number maxValue;
    private static Color GOOD = Color.white;
    private static Color BAD = new Color(255, 192, 192);

    public NumberPropertyEditor() {
        this("", Double.class, null, null);
    }

    public NumberPropertyEditor(String propertyName, Class requiredType, Number min, Number max) {
        this.propertyName = propertyName;
        this.requiredType = requiredType;
        this.minValue = min;
        this.maxValue = max;
        if (requiredType != Integer.class && requiredType != Long.class && requiredType != Float.class && requiredType != Double.class) {
            throw new IllegalArgumentException("type must be Integer, Long, Float, or Double");
        }
        this.textField = new PropSheetJTextField(12);
        this.textField.getDocument().addDocumentListener(this);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.textField;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.textField.setText("");
        } else if (value.toString().equals("")) {
            this.textField.setText("");
        } else if (this.requiredType.isInstance(value)) {
            String stringValue = value.toString();
            this.checkValue(stringValue);
            this.textField.setText(stringValue);
        } else {
            throw new IllegalArgumentException("value must be a String");
        }
    }

    @Override
    public void setAsText(String stringValue) {
        this.checkValue(stringValue);
        this.textField.setText(stringValue);
    }

    @Override
    public Object getValue() {
        String stringValue = this.getAsText();
        if (stringValue.equals("")) {
            return stringValue;
        }
        if (this.requiredType == Integer.class) {
            return new Integer(stringValue);
        }
        if (this.requiredType == Long.class) {
            return new Long(stringValue);
        }
        if (this.requiredType == Float.class) {
            return new Float(stringValue);
        }
        if (this.requiredType == Double.class) {
            return new Double(stringValue);
        }
        return stringValue;
    }

    @Override
    public String getAsText() {
        String currentViewValue = this.textField.getText();
        this.checkValue(currentViewValue);
        return currentViewValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Class getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(Class requiredType) {
        this.requiredType = requiredType;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Number minValue) {
        this.minValue = minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
    }

    private void checkValue(String stringValue) {
        if (stringValue == null) {
            throw new IllegalArgumentException("You must specify a value for " + this.propertyName);
        }
        if (stringValue.equals("")) {
            return;
        }
        double value = Integer.class.isAssignableFrom(this.requiredType) || Long.class.isAssignableFrom(this.requiredType) ? (double)Long.parseLong(stringValue) : Double.parseDouble(stringValue);
        if (this.minValue != null && value < this.minValue.doubleValue()) {
            throw new IllegalArgumentException(this.propertyName + ": value is less than " + this.minValue);
        }
        if (this.maxValue != null && value > this.maxValue.doubleValue()) {
            throw new IllegalArgumentException(this.propertyName + ": value is greater than " + this.maxValue);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.checkDoc();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.checkDoc();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.checkDoc();
    }

    private void checkDoc() {
        block3: {
            Color background = this.textField.getBackground();
            String stringValue = this.textField.getText();
            this.firePropertyChange();
            try {
                this.checkValue(stringValue);
                if (background != GOOD) {
                    this.textField.setBackground(GOOD);
                }
            }
            catch (Exception e) {
                if (background == BAD) break block3;
                this.textField.setBackground(BAD);
            }
        }
    }

    private static class PropSheetJTextField
    extends JTextField {
        public PropSheetJTextField() {
        }

        public PropSheetJTextField(int length) {
            super(length);
        }

        @Override
        public boolean isFocusTraversable() {
            return this.isEnabled() && this.isEditable();
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled != this.isEnabled()) {
                super.setEnabled(enabled);
                this.setBackground(enabled ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            }
        }
    }
}

