/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.Serializable;
import modelobjects.util.StringMatcher;

public class PatternSet
implements Serializable {
    private StringMatcher[] includePatterns;
    private StringMatcher[] excludePatterns;
    private int numIncludePatterns;
    private int numExcludePatterns;

    public PatternSet() {
        this(null, null);
    }

    public PatternSet(StringMatcher[] includePatterns, StringMatcher[] excludePatterns) {
        this.setIncludePatterns(includePatterns);
        this.setExcludePatterns(excludePatterns);
    }

    public boolean matches(String s) {
        int i;
        for (i = 0; i < this.numExcludePatterns; ++i) {
            if (!this.excludePatterns[i].matches(s)) continue;
            return false;
        }
        for (i = 0; i < this.numIncludePatterns; ++i) {
            if (!this.includePatterns[i].matches(s)) continue;
            return true;
        }
        return false;
    }

    public StringMatcher[] getIncludePatterns() {
        return this.includePatterns;
    }

    public final void setIncludePatterns(StringMatcher[] includePatterns) {
        this.includePatterns = includePatterns;
        this.numIncludePatterns = includePatterns == null ? 0 : includePatterns.length;
    }

    public StringMatcher[] getExcludePatterns() {
        return this.excludePatterns;
    }

    public final void setExcludePatterns(StringMatcher[] excludePatterns) {
        this.excludePatterns = excludePatterns;
        this.numExcludePatterns = excludePatterns == null ? 0 : excludePatterns.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PatternSet[");
        buf.append("include:[");
        int numIncludes = this.includePatterns == null ? 0 : this.includePatterns.length;
        for (int i = 0; i < numIncludes; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.includePatterns[i].toString());
        }
        buf.append("]");
        buf.append(", exclude:[");
        int numExcludes = this.excludePatterns == null ? 0 : this.excludePatterns.length;
        for (int i = 0; i < numExcludes; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.excludePatterns[i].toString());
        }
        buf.append("]");
        buf.append("]");
        return buf.toString();
    }
}

