/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.util.ArrayList;
import java.util.Comparator;
import modelobjects.util.DefaultComparator;
import modelobjects.util.ReverseComparator;
import modelobjects.util.swing.ModelListTableModel;
import modelobjects.util.swing.TableColumnAdapter;

public class SortedArrayList
extends ArrayList {
    TableColumnAdapter tableColumnAdapter;
    ModelListTableModel tableModel;
    Comparator sortComparator;

    public SortedArrayList() {
        this(DefaultComparator.getInstance());
    }

    public SortedArrayList(Comparator sortComparator) {
        this.tableColumnAdapter = new WholeObjectTableColumnAdapter(sortComparator);
        TableColumnAdapter[] columnAdapters = new TableColumnAdapter[]{this.tableColumnAdapter};
        this.tableModel = new ModelListTableModel(columnAdapters, this);
        this.tableModel.sortByColumn(0, true);
    }

    @Override
    public int indexOf(Object obj) {
        if (this.tableModel.getSortComparator() != null) {
            return this.tableModel.getIndexOf(obj);
        }
        return super.indexOf(obj);
    }

    public Comparator getSortComparator() {
        return this.sortComparator;
    }

    public void setSortComparator(Comparator sortComparator) {
        this.tableColumnAdapter.setRowComparator(sortComparator);
        this.tableModel.sortByColumn(0, true);
    }

    @Override
    public boolean add(Object obj) {
        this.tableModel.insertRowMaintainSort(obj);
        return true;
    }

    @Override
    public void add(int index, Object obj) {
        super.add(index, obj);
        this.tableModel.rowChanged(index);
    }

    @Override
    public Object set(int index, Object obj) {
        Object prev = super.set(index, obj);
        this.tableModel.rowChanged(index);
        return prev;
    }

    public boolean isSorted() {
        return this.tableModel.getSortComparator() != null;
    }

    public void sort(boolean ascending) {
        this.tableModel.sortByColumn(0, ascending);
    }

    public static void main(String[] args) {
        SortedArrayList list = new SortedArrayList();
        for (int i = 0; i < args.length; ++i) {
            list.add(args[i]);
        }
        System.out.println("isSorted = " + list.isSorted());
        System.out.println("list(1) = " + list);
        list.sort(false);
        System.out.println("list(2) = " + list);
        list.sort(true);
        System.out.println("list(3) = " + list);
        Comparator reverseComparator = ReverseComparator.makeReverseComparator(DefaultComparator.getInstance());
        list.setSortComparator(reverseComparator);
        System.out.println("list(4) = " + list);
    }

    static class WholeObjectTableColumnAdapter
    extends TableColumnAdapter {
        public WholeObjectTableColumnAdapter(Comparator comparator) {
            super("", false, Object.class, 100, 100, 100);
            this.setProperties(comparator);
        }

        private void setProperties(Comparator comparator) {
            this.setRowComparator(comparator);
        }

        @Override
        public Object getColumnValue(Object rowModel, int rowNumber) {
            return rowModel;
        }

        @Override
        public void setColumnValue(Object rowModel, Object columnValue) {
        }
    }
}

