/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.Serializable;

public abstract class StringMatcher
implements Serializable {
    static final char DEFAULT_WILDCARD_CHAR = '*';

    public static boolean stringMatches(String s, String pattern) {
        return StringMatcher.stringMatches(s, pattern, '*');
    }

    public static boolean stringMatches(String s, String pattern, char wildcardChar) {
        StringMatcher matcher = StringMatcher.parsePattern(pattern, wildcardChar);
        return matcher.matchIndex(s) != -1;
    }

    public final boolean matches(String s) {
        return this.matchIndex(s) != -1;
    }

    public static StringMatcher parsePattern(String pattern) {
        return StringMatcher.parsePattern(pattern, false, '*');
    }

    public static StringMatcher parsePattern(String pattern, char wildcardChar) {
        return StringMatcher.parsePattern(pattern, false);
    }

    public static StringMatcher parseFilePattern(String pattern) {
        return StringMatcher.parseFilePattern(pattern, '*');
    }

    public static StringMatcher parseFilePattern(String pattern, char wildcardChar) {
        return StringMatcher.parsePattern(pattern, StringMatcher.getIgnoreFilenameCaseOnPlatform(), wildcardChar);
    }

    public static boolean getIgnoreFilenameCaseOnPlatform() {
        return ObjectLazyHolder.IGNORE_FILENAME_CASE_ON_PLATFORM;
    }

    public static StringMatcher parsePattern(String pattern, boolean ignoreCase) {
        return StringMatcher.parsePattern(pattern, ignoreCase, '*');
    }

    public static StringMatcher parsePattern(String pattern, boolean ignoreCase, char wildcardChar) {
        int wildCardIndex = pattern.indexOf(wildcardChar);
        if (wildCardIndex == -1) {
            return new FullMatcher(pattern, ignoreCase);
        }
        if (wildCardIndex == pattern.length() - 1) {
            return new StartsWithMatcher(pattern.substring(0, wildCardIndex), ignoreCase);
        }
        if (wildCardIndex == 0) {
            int nextWildCard = pattern.indexOf(wildcardChar, 1);
            if (nextWildCard == -1) {
                return new EndsWithMatcher(pattern.substring(1), ignoreCase);
            }
            ContainsMatcher m1 = new ContainsMatcher(pattern.substring(1, nextWildCard), ignoreCase);
            if (nextWildCard == pattern.length() - 1) {
                return m1;
            }
            StringMatcher m2 = StringMatcher.parsePattern(pattern.substring(nextWildCard), ignoreCase, wildcardChar);
            return new CompoundMatcher(m1, m2);
        }
        StartsWithMatcher m1 = new StartsWithMatcher(pattern.substring(0, wildCardIndex), ignoreCase);
        StringMatcher m2 = StringMatcher.parsePattern(pattern.substring(wildCardIndex), ignoreCase, wildcardChar);
        return new CompoundMatcher(m1, m2);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Args:  <pattern> [ <sampleString> ]");
        } else {
            try {
                StringMatcher matcher = StringMatcher.parsePattern(args[0], true, '*');
                System.out.println(matcher);
                if (args.length > 1) {
                    System.out.println("Match index on \"" + args[1] + "\" = " + matcher.matchIndex(args[1]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public abstract int matchIndex(String var1);

    public abstract int matchIndex(String var1, int var2);

    private static final class ContainsMatcher
    extends StringMatcher {
        private String fragment;
        private int fragmentLength;
        private boolean ignoreCase;

        ContainsMatcher(String fragment, boolean ignoreCase) {
            this.fragment = fragment;
            this.fragmentLength = fragment.length();
            this.ignoreCase = ignoreCase;
        }

        @Override
        public int matchIndex(String s) {
            return this.matchIndex(s, 0);
        }

        @Override
        public int matchIndex(String s, int startIndex) {
            int index = -1;
            if (this.ignoreCase) {
                int n = s.length() - this.fragmentLength;
                for (int i = startIndex; i <= n; ++i) {
                    if (!s.regionMatches(true, i, this.fragment, 0, this.fragmentLength)) continue;
                    index = i;
                    break;
                }
            } else {
                index = s.indexOf(this.fragment, startIndex);
            }
            return index == -1 ? -1 : index + this.fragmentLength;
        }

        public String toString() {
            return "contains(\"" + this.fragment + "\")";
        }
    }

    private static final class EndsWithMatcher
    extends StringMatcher {
        private String suffix;
        private int suffixLength;
        private boolean ignoreCase;

        EndsWithMatcher(String suffix, boolean ignoreCase) {
            this.suffix = suffix;
            this.suffixLength = suffix.length();
            this.ignoreCase = ignoreCase;
        }

        @Override
        public int matchIndex(String s) {
            boolean match = s.regionMatches(this.ignoreCase, s.length() - this.suffixLength, this.suffix, 0, this.suffixLength);
            return match ? s.length() : -1;
        }

        @Override
        public int matchIndex(String s, int startIndex) {
            if (s.length() - startIndex >= this.suffixLength) {
                return this.matchIndex(s);
            }
            return -1;
        }

        public String toString() {
            return "endsWith(\"" + this.suffix + "\")";
        }
    }

    private static final class StartsWithMatcher
    extends StringMatcher {
        private String prefix;
        private int prefixLength;
        private boolean ignoreCase;

        StartsWithMatcher(String prefix, boolean ignoreCase) {
            this.prefix = prefix;
            this.prefixLength = prefix.length();
            this.ignoreCase = ignoreCase;
        }

        @Override
        public int matchIndex(String s) {
            return this.matchIndex(s, 0);
        }

        @Override
        public int matchIndex(String s, int startIndex) {
            boolean match = s.regionMatches(this.ignoreCase, startIndex, this.prefix, 0, this.prefixLength);
            return match ? this.prefixLength + startIndex : -1;
        }

        public String toString() {
            return "startsWith(\"" + this.prefix + "\")";
        }
    }

    private static final class FullMatcher
    extends StringMatcher {
        private String literal;
        private int literalLength;
        private boolean ignoreCase;

        FullMatcher(String literal, boolean ignoreCase) {
            this.literal = literal;
            this.literalLength = literal.length();
            this.ignoreCase = ignoreCase;
        }

        @Override
        public int matchIndex(String s) {
            boolean matches = this.ignoreCase ? s.equalsIgnoreCase(this.literal) : s.equals(this.literal);
            return matches ? this.literalLength : -1;
        }

        @Override
        public int matchIndex(String s, int startIndex) {
            return startIndex == 0 ? this.matchIndex(s) : -1;
        }

        public String toString() {
            return "equals(\"" + this.literal + "\")";
        }
    }

    private static final class CompoundMatcher
    extends StringMatcher {
        private StringMatcher m1;
        private StringMatcher m2;

        CompoundMatcher(StringMatcher m1, StringMatcher m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        @Override
        public int matchIndex(String s) {
            int index1 = this.m1.matchIndex(s);
            return index1 == -1 ? -1 : this.m2.matchIndex(s, index1);
        }

        @Override
        public int matchIndex(String s, int startIndex) {
            int index1 = this.m1.matchIndex(s, startIndex);
            return index1 == -1 ? -1 : this.m2.matchIndex(s, index1);
        }

        public String toString() {
            return this.m1 + " & " + this.m2;
        }
    }

    private static class ObjectLazyHolder {
        private static final Boolean IGNORE_FILENAME_CASE_ON_PLATFORM = System.getProperty("os.name").startsWith("Windows");

        private ObjectLazyHolder() {
        }
    }
}

