/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WeakValueMap
extends HashMap {
    private ReferenceQueue refQueue = new ReferenceQueue();

    @Override
    public Object put(Object key, Object value) {
        this.processRefQueue();
        WeakValue weakVal = new WeakValue(value, this.refQueue, key);
        WeakValue prev = super.put(key, weakVal);
        return prev == null ? null : prev.get();
    }

    @Override
    public Object get(Object key) {
        WeakValue val = (WeakValue)super.get(key);
        return val == null ? null : val.get();
    }

    @Override
    public Object remove(Object key) {
        this.processRefQueue();
        WeakValue prev = (WeakValue)super.remove(key);
        return prev == null ? null : prev.get();
    }

    @Override
    public boolean containsValue(Object obj) {
        for (WeakValue wv : this.values()) {
            Object val = wv.get();
            if (val != obj && (val == null || !val.equals(obj))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        boolean first = true;
        for (Map.Entry entry : this.entrySet()) {
            Object key = entry.getKey();
            Object val = ((WeakValue)entry.getValue()).get();
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(key + "=" + val);
        }
        buf.append("}");
        return buf.toString();
    }

    public void clean() {
        this.processRefQueue();
    }

    private void processRefQueue() {
        WeakValue wv;
        while ((wv = (WeakValue)this.refQueue.poll()) != null) {
            this.remove(wv.key);
            wv.key = null;
        }
    }

    private static class WeakValue
    extends WeakReference {
        Object key;

        WeakValue(Object value, ReferenceQueue refQueue, Object key) {
            super(value, refQueue);
            this.key = key;
        }
    }
}

