/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class XmlWritable {
    private static final char TAG_OPEN = '<';
    private static final char TAG_CLOSE = '>';
    private static final char FORWARD_SLASH = '/';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char EQUALS = '=';
    private String elementName;
    private String pcdataContent;
    private Map attributes;
    private List namespaceAttributes;
    private boolean allowsIndent;

    public XmlWritable(String elementName) {
        this(elementName, true);
    }

    public XmlWritable(String elementName, boolean allowsIndent) {
        this.elementName = elementName;
        this.allowsIndent = allowsIndent;
        this.attributes = new HashMap();
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public List getNamespaceAttributes() {
        return this.namespaceAttributes;
    }

    public void addNamespaceAttribute(String attributeName, String attributeValue) {
        if (this.namespaceAttributes == null) {
            this.namespaceAttributes = new ArrayList();
        }
        if (!attributeName.equals("xmlns") && !attributeName.startsWith("xmlns:")) {
            throw new IllegalArgumentException("namespace attribute names must start with 'xmlns'");
        }
        NamespaceAttribute namespaceAttr = new NamespaceAttribute(attributeName, attributeValue);
        this.namespaceAttributes.add(namespaceAttr);
    }

    public String getPCDataContent() {
        return this.pcdataContent;
    }

    public void setPCDataContent(String pcdataContent) {
        this.pcdataContent = pcdataContent;
    }

    public abstract List getChildren();

    public boolean getAllowsIndent() {
        return this.allowsIndent;
    }

    public void setAllowsIndent(boolean allowsIndent) {
        this.allowsIndent = allowsIndent;
    }

    public static String makeCDataTag(String s) {
        return "<![CDATA[" + s + "]]>";
    }

    public void writeAsXML(PrintWriter out) {
        this.writeAsXML(out, "  ", 0);
        out.println();
        out.flush();
    }

    public void writeAsXML(PrintWriter out, String indentString) {
        this.writeAsXML(out, indentString, 0);
    }

    private void writeAsXML(PrintWriter out, String indentString, int indentLevel) {
        boolean hasPCData;
        List nsAttrs = this.getNamespaceAttributes();
        Map attributes = this.getAttributes();
        List children = this.getChildren();
        String elemName = this.getElementName();
        boolean hasChildren = children != null && !children.isEmpty();
        boolean bl = hasPCData = this.pcdataContent != null && this.pcdataContent.length() > 0;
        if (hasChildren) {
            out.println();
        }
        int lineLength = this.startNewLine(out, indentString, indentLevel);
        lineLength += elemName.length() + 1;
        out.print('<');
        out.print(elemName);
        if (nsAttrs != null) {
            int n = nsAttrs.size();
            for (int i = 0; i < n; ++i) {
                NamespaceAttribute nsa = (NamespaceAttribute)nsAttrs.get(i);
                String attrName = nsa.getName();
                String attrValue = nsa.getValue();
                lineLength = this.writeAttr(out, indentString, indentLevel, attrName, attrValue, lineLength);
            }
        }
        if (attributes != null) {
            for (Map.Entry attr : attributes.entrySet()) {
                String attrName = attr.getKey().toString();
                String attrValue = attr.getValue().toString();
                lineLength = this.writeAttr(out, indentString, indentLevel, attrName, attrValue, lineLength);
            }
        }
        if (!hasChildren && !hasPCData) {
            out.print('/');
            out.print('>');
        } else {
            out.print('>');
            if (hasChildren) {
                for (XmlWritable child : children) {
                    child.writeAsXML(out, indentString, indentLevel + 1);
                }
            } else if (hasPCData) {
                out.print(this.pcdataContent);
            }
            if (this.allowsIndent && hasChildren) {
                this.startNewLine(out, indentString, indentLevel);
            }
            out.print('<');
            out.print('/');
            out.print(elemName);
            out.print('>');
        }
    }

    private int writeAttr(PrintWriter out, String indentString, int indentLevel, String attrName, String attrValue, int lineLength) {
        if (lineLength + attrName.length() + attrValue.length() >= 75) {
            this.startNewLine(out, indentString, indentLevel + 3);
            lineLength = indentString.length() * (indentLevel + 3);
        } else {
            out.print(' ');
        }
        lineLength += attrName.length() + attrValue.length() + 4;
        out.print(attrName);
        out.print('=');
        out.print('\"');
        out.print(attrValue);
        out.print('\"');
        return lineLength;
    }

    protected int startNewLine(PrintWriter out, String indentString, int indentLevel) {
        out.println();
        if (this.allowsIndent) {
            for (int i = 0; i < indentLevel; ++i) {
                out.print(indentString);
            }
            return indentString.length() * indentLevel;
        }
        return 0;
    }

    public static XmlWritable makePCDataElement(String xmlTag, String pcData, boolean useCDataWrapper) {
        XmlWritable result = new XmlWritable(xmlTag){

            @Override
            public List getChildren() {
                return Collections.EMPTY_LIST;
            }
        };
        String content = useCDataWrapper ? XmlWritable.makeCDataTag(pcData) : pcData;
        result.setPCDataContent(content);
        return result;
    }

    public static XmlWritable makeEmptyContentElement(String xmlTag) {
        XmlWritable result = new XmlWritable(xmlTag){

            @Override
            public List getChildren() {
                return Collections.EMPTY_LIST;
            }
        };
        return result;
    }

    public static class NamespaceAttribute {
        private String name;
        private String value;

        public NamespaceAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

