/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BasicTableCellEditor
extends DefaultCellEditor {
    private JComboBox comboBox;
    private JTextField textField;
    private StringConverter converter;
    private static final Color GOOD = Color.white;
    private static volatile Color BAD = new Color(255, 192, 192);

    public static BasicTableCellEditor makeCellEditor(Class cellType) {
        if (cellType == Boolean.class) {
            return BasicTableCellEditor.makeBooleanEditor();
        }
        if (cellType == String.class) {
            return BasicTableCellEditor.makeStringEditor();
        }
        if (cellType == Integer.class) {
            return BasicTableCellEditor.makeNumericEditor(new IntegerConverter());
        }
        if (cellType == Long.class) {
            return BasicTableCellEditor.makeNumericEditor(new LongConverter());
        }
        if (cellType == Float.class) {
            return BasicTableCellEditor.makeNumericEditor(new FloatConverter());
        }
        if (cellType == Double.class) {
            return BasicTableCellEditor.makeNumericEditor(new DoubleConverter());
        }
        if (cellType == Byte.class) {
            return BasicTableCellEditor.makeNumericEditor(new ByteConverter());
        }
        if (cellType == Short.class) {
            return BasicTableCellEditor.makeNumericEditor(new ShortConverter());
        }
        return BasicTableCellEditor.makeStringEditor();
    }

    public static BasicTableCellEditor makeBooleanEditor() {
        Object[] values = new Object[]{Boolean.FALSE, Boolean.TRUE};
        JComboBox<Object> comboBox = new JComboBox<Object>(values);
        comboBox.setEditable(false);
        NoopConverter converter = new NoopConverter();
        BasicTableCellEditor editor = new BasicTableCellEditor(comboBox, (StringConverter)converter);
        return editor;
    }

    public static BasicTableCellEditor makeStringEditor() {
        NoopConverter converter = new NoopConverter();
        JTextField textField = new JTextField();
        BasicTableCellEditor editor = new BasicTableCellEditor(textField, (StringConverter)converter);
        return editor;
    }

    public static BasicTableCellEditor makeJavaIdentifierEditor() {
        JavaIdentifierConverter converter = new JavaIdentifierConverter();
        JTextField textField = new JTextField();
        BasicTableCellEditor editor = new BasicTableCellEditor(textField, (StringConverter)converter);
        return editor;
    }

    public static BasicTableCellEditor makeNumericEditor(StringConverter converter) {
        JTextField textField = new JTextField();
        BasicTableCellEditor editor = new BasicTableCellEditor(textField, converter);
        return editor;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.textField != null) {
            return this.converter.convert(this.textField.getText());
        }
        if (this.comboBox != null) {
            return this.comboBox.getSelectedItem();
        }
        return null;
    }

    public void setAlignment(int alignment) {
        if (this.textField != null) {
            this.textField.setHorizontalAlignment(alignment);
        }
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
            return super.stopCellEditing();
        }
        catch (RuntimeException e) {
            if (this.textField != null) {
                this.textField.setBackground(BAD);
            }
            return false;
        }
    }

    private BasicTableCellEditor(JComboBox comboBox, StringConverter converter) {
        super(comboBox);
        this.comboBox = comboBox;
        this.converter = converter;
    }

    private BasicTableCellEditor(JTextField textField, StringConverter converter) {
        super(textField);
        this.textField = textField;
        this.converter = converter;
        FieldValidator validator = new FieldValidator(textField, converter);
        textField.getDocument().addDocumentListener(validator);
    }

    public static Color getInvalidInputBackgroundColor() {
        return BAD;
    }

    public static void setInvalidInputBackgroundColor(Color color) {
        BAD = color;
    }

    static class FieldValidator
    implements DocumentListener {
        private JTextField textField;
        private StringConverter converter;

        FieldValidator(JTextField textField, StringConverter converter) {
            this.textField = textField;
            this.converter = converter;
        }

        void checkDoc() {
            block3: {
                Color background = this.textField.getBackground();
                String text = this.textField.getText();
                try {
                    this.converter.convert(text);
                    if (background != GOOD) {
                        this.textField.setBackground(GOOD);
                    }
                }
                catch (Exception e) {
                    if (background == BAD) break block3;
                    this.textField.setBackground(BAD);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.checkDoc();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.checkDoc();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.checkDoc();
        }
    }

    public static class JavaIdentifierConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            int length;
            int n = length = value == null ? 0 : value.length();
            if (length == 0) {
                throw new IllegalArgumentException("null name");
            }
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (i == 0) {
                    if (Character.isJavaIdentifierStart(c)) continue;
                    throw new IllegalArgumentException("bad first character in name");
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                throw new IllegalArgumentException("bad character in name");
            }
            return value;
        }
    }

    public static class DoubleConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Double.valueOf(value);
        }
    }

    public static class FloatConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Float.valueOf(value);
        }
    }

    public static class ByteConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Byte.decode(value);
        }
    }

    public static class ShortConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Short.decode(value);
        }
    }

    public static class LongConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Long.decode(value);
        }
    }

    public static class IntegerConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Integer.decode(value);
        }
    }

    public static class BooleanConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return Boolean.valueOf(value);
        }
    }

    public static class NoopConverter
    extends StringConverter {
        @Override
        public Object convert(String value) {
            return value;
        }
    }

    public static abstract class StringConverter {
        public abstract Object convert(String var1);
    }
}

