/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import modelobjects.util.FindClass;
import modelobjects.util.swing.TableColumnAdapter;

public class BeanPropertyTableColumnAdapter
extends TableColumnAdapter {
    private Method readMethod;
    private Method writeMethod;

    public BeanPropertyTableColumnAdapter(PropertyDescriptor propDesc, int minimumWidth, int preferredWidth, int maximumWidth) {
        this(propDesc, false, minimumWidth, preferredWidth, maximumWidth);
    }

    public BeanPropertyTableColumnAdapter(PropertyDescriptor propDesc, boolean includeTypeInColumnLabel, int minimumWidth, int preferredWidth, int maximumWidth) {
        super(BeanPropertyTableColumnAdapter.makeHeaderLabelString(propDesc, includeTypeInColumnLabel), propDesc.getWriteMethod() != null, BeanPropertyTableColumnAdapter.getColumnType(propDesc.getPropertyType()), minimumWidth, preferredWidth, maximumWidth);
        this.readMethod = propDesc.getReadMethod();
        this.writeMethod = propDesc.getWriteMethod();
    }

    private static String makeHeaderLabelString(PropertyDescriptor propDesc, boolean includeType) {
        if (includeType) {
            return "<html><font face=SansSerif size=2><center>" + BeanPropertyTableColumnAdapter.capitalize(propDesc.getName()) + "<br><font size=1>" + "(" + FindClass.getName(propDesc.getPropertyType(), true) + ")";
        }
        return BeanPropertyTableColumnAdapter.capitalize(propDesc.getName());
    }

    @Override
    public Object getColumnValue(Object rowModel, int rowNumber) {
        try {
            Object v = this.readMethod.invoke(rowModel, null);
            if (v == null || v instanceof Number || v instanceof Boolean) {
                return v;
            }
            return v.toString();
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getTargetException());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }

    @Override
    public void setColumnValue(Object rowModel, Object columnValue) {
        try {
            this.writeMethod.invoke(rowModel, columnValue);
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getTargetException());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0 || !Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static Class getColumnType(Class propType) {
        if (propType.isPrimitive()) {
            if (propType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (propType == Byte.TYPE) {
                return Byte.class;
            }
            if (propType == Character.TYPE) {
                return Character.class;
            }
            if (propType == Short.TYPE) {
                return Short.class;
            }
            if (propType == Integer.TYPE) {
                return Integer.class;
            }
            if (propType == Long.TYPE) {
                return Long.class;
            }
            if (propType == Float.TYPE) {
                return Float.class;
            }
            if (propType == Double.TYPE) {
                return Double.class;
            }
        } else if (Number.class.isAssignableFrom(propType)) {
            return propType;
        }
        return String.class;
    }
}

