/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;

public class ColorIcon
implements Icon,
Serializable {
    private boolean large;
    private Color color;
    private Color borderColor = Color.black;
    private String labelString;

    public ColorIcon() {
        this(Color.white, false);
    }

    public ColorIcon(Color color) {
        this(color, false);
    }

    public ColorIcon(Color color, boolean large) {
        this.color = color;
        this.large = large;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public char getLabelChar() {
        return this.labelString == null ? (char)'\u0000' : this.labelString.charAt(0);
    }

    public void setLabelChar(char labelChar) {
        this.labelString = labelChar == '\u0000' ? null : new String(new char[]{labelChar});
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.large) {
            g.setColor(this.color);
            g.fillRect(x + 1, y + 1, 12, 12);
            g.setColor(this.borderColor);
            g.drawRect(x + 1, y + 1, 12, 12);
            if (this.labelString != null) {
                g.setColor(this.getLabelColor());
                g.setFont(c.getFont());
                g.drawString(this.labelString, x + 3, y + 12);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(x + 3, y + 3, 8, 8);
            g.setColor(this.borderColor);
            g.drawRect(x + 3, y + 3, 8, 8);
        }
    }

    private Color getLabelColor() {
        int g;
        int b;
        Color c = this.color;
        int r = c.getRed();
        return r + (b = c.getBlue()) + (g = c.getGreen()) < 200 ? Color.white : Color.black;
    }
}

