/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Component;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import modelobjects.util.swing.ModelListTableModel;
import modelobjects.util.swing.ModelTable;
import modelobjects.util.swing.TableColumnAdapter;

public class DirectoryFileTable
extends ModelTable {
    ModelListTableModel tableModel;

    public DirectoryFileTable() {
        super(DirectoryFileTable.makeTableColumns());
    }

    static TableColumnAdapter[] makeTableColumns() {
        return new TableColumnAdapter[]{new FileNameColumnAdapter(), new FileSizeColumnAdapter(), new FileDateColumnAdapter()};
    }

    public void setDirectory(File directory) {
        ArrayList<File> contents = new ArrayList<File>();
        if (directory != null) {
            File[] files = directory.listFiles();
            int numFiles = files == null ? 0 : files.length;
            for (int i = 0; i < numFiles; ++i) {
                contents.add(files[i]);
            }
        }
        this.tableModel.setContents(contents);
        this.tableModel.sortByColumn(0);
        this.getTableHeader().repaint();
    }

    public static void main(String[] args) {
        String dirName = args.length == 0 ? "." : args[0];
        DirectoryFileTable table = new DirectoryFileTable();
        table.setDirectory(new File(dirName));
        JFrame window = new JFrame("DirectoryFileTable Test");
        window.setDefaultCloseOperation(3);
        window.setBounds(300, 200, 600, 400);
        window.getContentPane().add((Component)new JScrollPane(table), "Center");
        window.setVisible(true);
    }

    static class FileNameComparator
    implements Comparator {
        FileNameComparator() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public int compare(Object obj1, Object obj2) {
            File file1 = (File)obj1;
            File file2 = (File)obj2;
            if (file1 == file2 || file1.equals(file2)) {
                return 0;
            }
            if (file1.isDirectory() == file2.isDirectory()) {
                return file1.getPath().compareTo(file2.getPath());
            }
            return file1.isDirectory() ? -1 : 1;
        }
    }

    static class FileNameCellRenderer
    extends DefaultTableCellRenderer {
        FileNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer result = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row >= 0) {
                ModelListTableModel tableModel = (ModelListTableModel)table.getModel();
                File file = (File)tableModel.getRowModel(row);
                if (file.isDirectory()) {
                    result.setIcon(UIManager.getIcon("FileView.directoryIcon"));
                } else {
                    result.setIcon(UIManager.getIcon("FileView.fileIcon"));
                }
            }
            return result;
        }
    }

    static class DateCellRenderer
    extends DefaultTableCellRenderer {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");

        DateCellRenderer() {
            this.setHorizontalAlignment();
        }

        private void setHorizontalAlignment() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = value instanceof Date ? this.dateFormat.format((Date)value) : "";
            return super.getTableCellRendererComponent(table, stringValue, isSelected, hasFocus, row, column);
        }
    }

    static class FileDateColumnAdapter
    extends TableColumnAdapter {
        FileDateColumnAdapter() {
            super("Date", false, Date.class, 40, 120, 600);
            this.setCellRenderer(new DateCellRenderer());
        }

        @Override
        public Object getColumnValue(Object rowModel, int rowNumber) {
            File file = (File)rowModel;
            long time = file.lastModified();
            return time == 0L ? null : new Date(time);
        }

        @Override
        public void setColumnValue(Object rowModel, Object columnValue) {
        }
    }

    static class FileSizeColumnAdapter
    extends TableColumnAdapter {
        FileSizeColumnAdapter() {
            super("Size", false, Long.class, 20, 60, 400, new DefaultTableCellRenderer(), null);
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.getCellRenderer();
            renderer.setHorizontalAlignment(4);
        }

        @Override
        public Object getColumnValue(Object rowModel, int rowNumber) {
            File file = (File)rowModel;
            return new Long(file.length());
        }

        @Override
        public void setColumnValue(Object rowModel, Object columnValue) {
        }
    }

    static class FileNameColumnAdapter
    extends TableColumnAdapter {
        FileNameColumnAdapter() {
            super("Name", false, String.class, 40, 150, 1000);
            this.setProperties();
        }

        private void setProperties() {
            this.setCellRenderer(new FileNameCellRenderer());
            this.setRowComparator(new FileNameComparator());
        }

        @Override
        public Object getColumnValue(Object rowModel, int rowNumber) {
            return ((File)rowModel).getName();
        }

        @Override
        public void setColumnValue(Object rowModel, Object columnValue) {
        }
    }
}

