/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import modelobjects.util.SortedArrayList;
import modelobjects.util.swing.DynamicTreeNode;

public class DirectoryFileTreeNode
extends DynamicTreeNode {
    private File file;
    private boolean dirsOnly;
    private static Comparator fileComparator = new FileComparator();

    public DirectoryFileTreeNode(File file, boolean dirsOnly) {
        super(file, file.isDirectory());
        this.file = file;
        this.dirsOnly = dirsOnly;
    }

    @Override
    protected List computeChildren() {
        SortedArrayList childrenNodes = new SortedArrayList(fileComparator);
        File[] files = this.file.listFiles();
        int numFiles = files == null ? 0 : files.length;
        for (int i = 0; i < numFiles; ++i) {
            if (this.dirsOnly && !files[i].isDirectory()) continue;
            childrenNodes.add(new DirectoryFileTreeNode(files[i], this.dirsOnly));
        }
        return childrenNodes;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        String name = this.file.getName();
        if (name.equals(".")) {
            return this.file.getAbsolutePath();
        }
        return name;
    }

    private static class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public int compare(Object obj1, Object obj2) {
            File file2;
            DirectoryFileTreeNode node1 = (DirectoryFileTreeNode)obj1;
            DirectoryFileTreeNode node2 = (DirectoryFileTreeNode)obj2;
            File file1 = node1.getFile();
            if (file1 == (file2 = node2.getFile()) || file1.equals(file2)) {
                return 0;
            }
            if (file1.isDirectory() == file2.isDirectory()) {
                return file1.getPath().compareTo(file2.getPath());
            }
            return file1.isDirectory() ? -1 : 1;
        }
    }
}

