/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class DynamicTreeNode
extends DefaultMutableTreeNode {
    private static final Collator collator = Collator.getInstance();
    protected boolean hasComputedChildren;
    protected boolean sortChildren = true;
    private transient Icon leafIcon;
    private transient Icon openIcon;
    private transient Icon closedIcon;

    public DynamicTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    protected abstract List computeChildren();

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            DynamicTreeNode that = (DynamicTreeNode)other;
            return this.getUserObject().equals(that.getUserObject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getUserObject());
    }

    public boolean isSortChildren() {
        return this.sortChildren;
    }

    public void setSortChildren(boolean sortChildren) {
        this.sortChildren = sortChildren;
    }

    public Icon getNodeIcon(boolean isExpanded, boolean isSelected, boolean isLeaf, boolean hasFocus) {
        return this.getAllowsChildren() ? (isSelected ? this.getOpenIcon() : this.getClosedIcon()) : this.getLeafIcon();
    }

    public String getNodeString(boolean isExpanded, boolean isSelected, boolean isLeaf, boolean hasFocus) {
        return this.toString();
    }

    public Icon getLeafIcon() {
        if (this.leafIcon == null) {
            this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        if (this.openIcon == null) {
            this.openIcon = UIManager.getIcon("Tree.openIcon");
        }
        return this.openIcon;
    }

    public Icon getClosedIcon() {
        if (this.closedIcon == null) {
            this.closedIcon = UIManager.getIcon("Tree.closedIcon");
        }
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public void releaseChildren() {
        if (this.hasComputedChildren) {
            this.removeAllChildren();
            this.hasComputedChildren = false;
        }
    }

    public void refresh(JTree tree, DefaultTreeModel treeModel) {
        DynamicTreeNode node;
        int i;
        if (!this.hasComputedChildren) {
            return;
        }
        List currentChildren = this.computeChildren();
        for (i = this.getChildCount() - 1; i >= 0; --i) {
            node = (DynamicTreeNode)this.getChildAt(i);
            if (currentChildren.contains(node)) continue;
            treeModel.removeNodeFromParent(node);
        }
        for (i = currentChildren.size() - 1; i >= 0; --i) {
            node = (DynamicTreeNode)currentChildren.get(i);
            if (this.children != null && this.children.contains(node)) continue;
            treeModel.insertNodeInto(node, this, -1);
        }
        this.refreshChildren(tree, treeModel);
    }

    protected void refreshChildren(JTree tree, DefaultTreeModel treeModel) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            DynamicTreeNode child = (DynamicTreeNode)this.getChildAt(i);
            child.refresh(tree, treeModel);
        }
    }

    @Override
    public boolean isLeaf() {
        if (this.hasComputedChildren && this.getChildCount() > 0) {
            return false;
        }
        return !this.getAllowsChildren();
    }

    public final List getchildren() {
        int count = this.getChildCount();
        if (count == 0) {
            return null;
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (int i = 0; i < count; ++i) {
            list.add(this.getChildAt(i));
        }
        return list;
    }

    public boolean getHasComputedChildren() {
        return this.hasComputedChildren;
    }

    protected final void computeChildrenIfNecessary() {
        if (this.getAllowsChildren() && !this.hasComputedChildren) {
            List children = this.computeChildren();
            if (children == null) {
                throw new IllegalStateException("computeChildren returned null");
            }
            this.hasComputedChildren = true;
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                this.add((DynamicTreeNode)children.get(i));
            }
        }
    }

    @Override
    public final int getChildCount() {
        if (this.getAllowsChildren()) {
            this.computeChildrenIfNecessary();
        }
        return super.getChildCount();
    }

    public final Enumeration children() {
        if (this.getAllowsChildren()) {
            this.computeChildrenIfNecessary();
        }
        return super.children();
    }

    @Override
    public final void add(MutableTreeNode child) {
        this.computeChildrenIfNecessary();
        if (!this.isSortChildren()) {
            super.add((DynamicTreeNode)child);
        } else {
            super.insert((DynamicTreeNode)child, this.getInsertIndex(child));
        }
    }

    @Override
    public final void insert(MutableTreeNode child, int index) {
        this.computeChildrenIfNecessary();
        if (this.isSortChildren() || index == -1) {
            super.insert((DynamicTreeNode)child, this.getInsertIndex(child));
        } else {
            super.insert((DynamicTreeNode)child, index);
        }
    }

    protected int getInsertIndex(MutableTreeNode child) {
        int index = this.getChildCount();
        for (int i = 0; i < this.getChildCount(); ++i) {
            MutableTreeNode node = (MutableTreeNode)this.getChildAt(i);
            if (collator.compare(child.toString(), node.toString()) > 0) continue;
            index = i;
            break;
        }
        return index;
    }
}

