/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import modelobjects.util.swing.DirectoryFileTable;
import modelobjects.util.swing.DirectoryFileTreeNode;
import modelobjects.util.swing.DynamicTreeCellRenderer;

public class DynamicTreeNodeTest
extends JFrame
implements ActionListener,
TreeSelectionListener {
    DirectoryFileTreeNode rootNode;
    JTree tree;
    DirectoryFileTable table;
    JButton refreshButton;

    public DynamicTreeNodeTest(File rootDir) {
        super("DynamicTreeNode Test");
        this.setProperties();
        this.table = new DirectoryFileTable();
        this.table.setRowHeight(this.table.getRowHeight() + 3);
        this.rootNode = new DirectoryFileTreeNode(rootDir, true);
        this.tree = new JTree(this.rootNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        this.tree.setCellRenderer(new DynamicTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.addContentPaneProperties();
    }

    private void setProperties() {
        this.setDefaultCloseOperation(3);
        this.setBounds(200, 200, 800, 500);
    }

    private void addContentPaneProperties() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        buttonPanel.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
        JScrollPane treeScroller = new JScrollPane(this.tree);
        JScrollPane tableScroller = new JScrollPane(this.table);
        treeScroller.getViewport().setBackground(this.tree.getBackground());
        tableScroller.getViewport().setBackground(this.table.getBackground());
        JSplitPane splitPane = new JSplitPane(1, treeScroller, tableScroller);
        splitPane.setDividerLocation(200);
        this.getContentPane().add((Component)buttonPanel, "North");
        this.getContentPane().add((Component)splitPane, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshButton) {
            this.rootNode.refresh(this.tree, (DefaultTreeModel)this.tree.getModel());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selection = this.tree.getSelectionPath();
        if (selection == null) {
            this.table.setDirectory(null);
        } else {
            File file;
            DirectoryFileTreeNode dirNode = (DirectoryFileTreeNode)selection.getLastPathComponent();
            if (dirNode.getChildCount() == 0) {
                this.tree.expandPath(selection);
            }
            this.table.setDirectory((file = dirNode.getFile()).isDirectory() ? file : null);
        }
    }

    public static void main(String[] args) throws Exception {
        String dirName = args.length == 0 ? "." : args[0];
        DynamicTreeNodeTest test = new DynamicTreeNodeTest(new File(dirName));
        test.setVisible(true);
    }
}

