/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import modelobjects.util.swing.IModelTableModel;
import modelobjects.util.swing.TableColumnAdapter;

public class HeaderCellRenderer
extends DefaultTableCellRenderer {
    private Icon m_iconAscend;
    private Icon m_iconDescend;
    private IModelTableModel m_tableModel;
    private TableColumnAdapter m_columnAdapter;

    public HeaderCellRenderer(IModelTableModel tableModel, TableColumnAdapter columnAdapter) {
        this.m_tableModel = tableModel;
        this.m_columnAdapter = columnAdapter;
        this.m_iconAscend = new TableArrowIcon(true);
        this.m_iconDescend = new TableArrowIcon(false);
        this.setProperties();
    }

    private void setProperties() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    @Override
    public void paint(Graphics g) {
        boolean sorted;
        super.paint(g);
        g.setColor(this.getForeground());
        boolean ascending = this.m_tableModel.isSortedInAscendingOrder();
        int sortColumn = this.m_tableModel.getSortColumn();
        boolean bl = sorted = sortColumn >= 0 && this.m_tableModel.getColumnAdapter(sortColumn) == this.m_columnAdapter;
        if (sorted) {
            Dimension size = this.getSize();
            Icon icon = ascending ? this.m_iconAscend : this.m_iconDescend;
            icon.paintIcon(this, g, size.width - icon.getIconWidth() - 4, (size.height - icon.getIconHeight() - 2) / 2);
        } else {
            this.setIcon(null);
        }
    }

    class TableArrowIcon
    implements Icon {
        private boolean isAscending;

        public TableArrowIcon(boolean isAscendingDirection) {
            this.isAscending = isAscendingDirection;
        }

        @Override
        public int getIconHeight() {
            return 5;
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.isAscending) {
                g.setColor((Color)UIManager.getDefaults().get("infoText"));
                g.drawLine(x, y + 3, x + 3, y);
                g.drawLine(x + 4, y, x + 4, y);
                g.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
                g.drawLine(x + 3, y + 1, x + 5, y + 1);
                g.drawLine(x + 2, y + 2, x + 6, y + 2);
                g.drawLine(x + 1, y + 3, x + 7, y + 3);
                g.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
                g.drawLine(x + 1, y + 4, x + 8, y + 4);
            } else {
                g.setColor((Color)UIManager.getDefaults().get("infoText"));
                g.drawLine(x, y, x + 7, y);
                g.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
                g.drawLine(x + 1, y + 1, x + 6, y + 1);
                g.drawLine(x + 2, y + 2, x + 5, y + 2);
                g.drawLine(x + 3, y + 3, x + 4, y + 3);
                g.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
                g.drawLine(x + 7, y + 1, x + 4, y + 4);
            }
        }
    }
}

