/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import modelobjects.util.swing.HeaderCellRenderer;
import modelobjects.util.swing.IModelTableModel;
import modelobjects.util.swing.ModelPropertyTableColumn;
import modelobjects.util.swing.TableColumnAdapter;

public class ModelListTableModel
extends AbstractTableModel
implements IModelTableModel,
TableColumnModelListener {
    private int m_columnCount;
    private TableColumnAdapter[] m_columnAdapters;
    private List contents;
    private TableColumnModel m_columnModel;
    private Comparator sortComparator;
    private int sortColumn;
    private boolean sortedAscending;
    private int lastRow = -1;
    private int lastCol = -1;
    private Object lastVal = null;

    public ModelListTableModel(TableColumnAdapter[] columnAdapters) {
        this(columnAdapters, new ArrayList());
    }

    public ModelListTableModel(TableColumnAdapter[] columnAdapters, List contents) {
        this.m_columnAdapters = columnAdapters;
        this.m_columnCount = columnAdapters.length;
        this.m_columnModel = this.makeColumnModel();
        this.setContents(contents);
    }

    public ModelListTableModel(Class rowModelClass, TableColumnAdapter[] columnAdapters, List contents) {
        this(columnAdapters, contents);
    }

    public ModelListTableModel(Class rowModelClass, TableColumnAdapter[] columnAdapters, List contents, int selectionMode) {
        this(columnAdapters, contents);
    }

    @Override
    public List getContents() {
        return this.contents;
    }

    @Override
    public final void setContents(List contents) {
        List oldContents = this.contents;
        this.contents = contents;
        this.invalidateCellCache();
        this.sortByColumn(this.getSortColumn());
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
        this.fireTableRowsInserted(0, contents.size());
    }

    @Override
    public TableColumnAdapter[] getColumnAdapters() {
        return this.m_columnAdapters;
    }

    @Override
    public TableColumnAdapter getColumnAdapter(int modelColumnIndex) {
        return this.m_columnAdapters[modelColumnIndex];
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        this.invalidateCellCache();
        super.fireTableChanged(event);
    }

    @Override
    public int getRowCount() {
        return this.contents.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnAdapter(columnIndex).getHeaderLabel();
    }

    @Override
    public Object getRowModel(int row) {
        return row >= 0 && row < this.contents.size() ? this.contents.get(row) : null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.m_columnAdapters[column].isColumnEditable(this.getRowModel(row));
    }

    @Override
    public int findCell(int startRow, int columnIndex, Object value) {
        for (int rowIndex = startRow; rowIndex < this.getRowCount(); ++rowIndex) {
            Object cellValue = this.getValueAt(rowIndex, columnIndex);
            if (cellValue == null && value == null) {
                return rowIndex;
            }
            if (cellValue == null || value == null || !value.equals(cellValue)) continue;
            return rowIndex;
        }
        return -1;
    }

    private int binarySearch(Object[] a, Object key, Comparator c) {
        int low = 0;
        int high = a.length - 1;
        int mid = -1;
        int cmp = -1;
        while (low <= high) {
            mid = low + high >> 1;
            Object midVal = a[mid];
            cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) break;
            high = mid - 1;
        }
        if (cmp == 0) {
            int i;
            if (a[mid].equals(key)) {
                return mid;
            }
            for (i = mid - 1; i >= 0 && c.compare(key, a[i]) == 0; --i) {
                if (!key.equals(a[i])) continue;
                return i;
            }
            for (i = mid + 1; i < a.length && c.compare(key, a[i]) == 0; ++i) {
                if (!key.equals(a[i])) continue;
                return i;
            }
            return -(mid + 1);
        }
        return -(low + 1);
    }

    @Override
    public int getIndexOf(Object obj) {
        if (this.sortComparator == null) {
            return this.contents.indexOf(obj);
        }
        return this.binarySearch(this.contents.toArray(), obj, this.sortComparator);
    }

    @Override
    public void insertRow(Object rowModel, int index) {
        this.contents.add(index, rowModel);
        this.fireTableRowsInserted(index, index);
        this.recheckSortedOrder(index);
    }

    @Override
    public void insertRowMaintainSort(Object rowModel) {
        int index = this.getIndexOf(rowModel);
        boolean refresh = false;
        if (index >= 0) {
            if (index < this.getRowCount() && this.contents.get(index).equals(rowModel)) {
                refresh = true;
            }
        } else {
            index = -1 - index;
        }
        if (refresh) {
            this.fireTableRowsUpdated(index, index);
        } else {
            this.contents.add(index, rowModel);
            this.fireTableRowsInserted(index, index);
        }
    }

    @Override
    public void deleteRow(int index) {
        this.contents.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public void delete(Object obj) {
        int row = this.getIndexOf(obj);
        if (row >= 0) {
            this.deleteRow(row);
        }
    }

    @Override
    public void clear() {
        int numRows = this.contents.size();
        if (numRows > 0) {
            this.contents.clear();
            this.fireTableRowsDeleted(0, numRows - 1);
        }
    }

    @Override
    public void rowChanged(int index) {
        this.fireTableRowsUpdated(index, index);
        this.recheckSortedOrder(index);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row == this.lastRow && column == this.lastCol) {
            return this.lastVal;
        }
        Object value = this.m_columnAdapters[column].getColumnValue(this.getRowModel(row), row);
        this.lastRow = row;
        this.lastCol = column;
        this.lastVal = value;
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.invalidateCellCache();
        this.m_columnAdapters[column].setColumnValue(this.getRowModel(row), value);
        this.recheckSortedOrder(row);
    }

    public TableCellRenderer getColumnCellRenderer(int columnIndex) {
        return this.m_columnAdapters[columnIndex].getCellRenderer();
    }

    public void setColumnCellRenderer(int columnIndex, TableCellRenderer cellRenderer) {
        this.m_columnAdapters[columnIndex].setCellRenderer(cellRenderer);
    }

    public TableCellEditor getColumnCellEditor(int columnIndex) {
        return this.m_columnAdapters[columnIndex].getCellEditor();
    }

    public void setColumnCellEditor(int columnIndex, TableCellEditor cellEditor) {
        this.m_columnAdapters[columnIndex].setCellEditor(cellEditor);
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_columnAdapters[columnIndex].getColumnClass();
    }

    private DefaultTableColumnModel makeColumnModel() {
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        for (int i = 0; i < this.m_columnAdapters.length; ++i) {
            TableColumnAdapter columnAdapter = this.m_columnAdapters[i];
            ModelPropertyTableColumn column = columnAdapter.makeModelPropertyTableColumn(i);
            column.setHeaderRenderer(new HeaderCellRenderer(this, columnAdapter));
            tcm.addColumn(column);
        }
        return tcm;
    }

    public TableColumnModel getTableColumnModel() {
        return this.m_columnModel;
    }

    private void invalidateCellCache() {
        this.lastRow = -1;
        this.lastCol = -1;
        this.lastVal = null;
    }

    @Override
    public void sortByColumn(int modelColumnIndex) {
        this.sortByColumn(modelColumnIndex, this.sortColumn != modelColumnIndex || !this.sortedAscending);
    }

    @Override
    public void sortByColumn(int modelColumnIndex, boolean ascending) {
        if (modelColumnIndex == -1) {
            return;
        }
        TableColumnAdapter columnAdapter = this.m_columnAdapters[modelColumnIndex];
        if (!columnAdapter.isColumnSortable()) {
            return;
        }
        Comparator comparator = ascending ? columnAdapter.getRowComparator() : columnAdapter.getReverseRowComparator();
        Object[] modelArray = this.contents.toArray();
        Arrays.sort(modelArray, comparator);
        this.contents.clear();
        int n = modelArray.length;
        for (int i = 0; i < n; ++i) {
            this.contents.add(i, modelArray[i]);
        }
        this.setSortedByColumn(modelColumnIndex, ascending);
        this.fireTableDataChanged();
    }

    @Override
    public void setSortedByColumn(int modelColumnIndex, boolean ascending) {
        Comparator oldComparator = this.sortComparator;
        int oldSortColumn = this.sortColumn;
        this.sortColumn = modelColumnIndex;
        this.sortedAscending = ascending;
        if (modelColumnIndex == -1) {
            this.sortComparator = null;
        } else {
            TableColumnAdapter columnAdapter = this.m_columnAdapters[modelColumnIndex];
            this.sortComparator = ascending ? columnAdapter.getRowComparator() : columnAdapter.getReverseRowComparator();
        }
        if (oldSortColumn != this.sortColumn || oldComparator != this.sortComparator) {
            this.fireTableStructureChanged();
        }
    }

    @Override
    public Comparator getSortComparator() {
        return this.sortComparator;
    }

    @Override
    public boolean isSorted() {
        return this.sortComparator != null;
    }

    void recheckSortedOrder(int rowNumber) {
        if (this.sortComparator != null && rowNumber >= 0) {
            Object nextRowModel;
            Object prevRowModel;
            Object rowModel = this.getRowModel(rowNumber);
            boolean sorted = true;
            if (rowNumber > 0 && this.sortComparator.compare(prevRowModel = this.getRowModel(rowNumber - 1), rowModel) > 0) {
                sorted = false;
            }
            if (sorted && rowNumber + 1 < this.contents.size() && this.sortComparator.compare(rowModel, nextRowModel = this.getRowModel(rowNumber + 1)) > 0) {
                sorted = false;
            }
            if (!sorted) {
                this.setSortedByColumn(-1, false);
            }
        }
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortedInAscendingOrder() {
        return this.sortedAscending;
    }

    @Override
    public void columnAdded(TableColumnModelEvent evt) {
        ++this.m_columnCount;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent evt) {
        --this.m_columnCount;
        if (this.sortColumn >= this.m_columnCount) {
            this.sortColumn = -1;
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent evt) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent evt) {
    }
}

