/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import modelobjects.util.swing.TableColumnAdapter;

public class ModelPropertyTableColumn
extends TableColumn {
    private TableColumnAdapter tableColumnAdapter;

    ModelPropertyTableColumn(int modelIndex, TableColumnAdapter tca) {
        super(modelIndex, tca.getPreferredWidth());
        this.tableColumnAdapter = tca;
        this.setProperties(tca);
    }

    private void setProperties(TableColumnAdapter tca) {
        this.setHeaderValue(tca.getHeaderLabel());
        this.setPreferredWidth(tca.getPreferredWidth());
        this.setMinWidth(tca.getMinimumWidth());
        this.setMaxWidth(tca.getMaximumWidth());
        this.setResizable(this.minWidth < this.maxWidth);
    }

    public TableColumnAdapter getTableColumnAdapter() {
        return this.tableColumnAdapter;
    }

    @Override
    public TableCellRenderer getCellRenderer() {
        return this.tableColumnAdapter.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TableCellRenderer renderer) {
        super.setCellRenderer(renderer);
        this.tableColumnAdapter.setCellRenderer(renderer);
    }

    @Override
    public TableCellEditor getCellEditor() {
        return this.tableColumnAdapter.getCellEditor();
    }

    @Override
    public void setCellEditor(TableCellEditor editor) {
        super.setCellEditor(editor);
        this.tableColumnAdapter.setCellEditor(editor);
    }

    public Class getColumnClass() {
        return this.tableColumnAdapter.getColumnClass();
    }

    public String toString() {
        return "TableColumn[" + this.tableColumnAdapter + "]";
    }
}

