/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import modelobjects.util.swing.HeaderCellRenderer;
import modelobjects.util.swing.IModelTableModel;
import modelobjects.util.swing.ModelListTableModel;
import modelobjects.util.swing.ModelPropertyTableColumn;
import modelobjects.util.swing.PopupMenuShower;
import modelobjects.util.swing.TableColumnAdapter;
import modelobjects.util.swing.TableSorter;

public class ModelTable
extends JTable {
    public ModelTable(TableColumnAdapter[] columnAdapters) {
        this(new ModelListTableModel(columnAdapters, new ArrayList()));
    }

    public ModelTable(IModelTableModel dm) {
        this(dm, null, null);
    }

    public ModelTable(IModelTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.prepareModelTable();
    }

    private void prepareModelTable() {
        this.setAutoResizeMode(0);
        this.setAutoCreateColumnsFromModel(false);
        this.getTableHeader().addMouseListener(new TableSorter(this));
        this.getTableHeader().addMouseListener(new PopupMenuShower(this, this.createHeaderPopupMenu()));
        this.getColumnModel().addColumnModelListener((TableColumnModelListener)((Object)this.getModel()));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (sp != null) {
            sp.getViewport().setBackground(this.getBackground());
            sp.getColumnHeader().setBackground(this.getBackground());
        }
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new ExtendedTableColumnModel();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        IModelTableModel tableModel = (IModelTableModel)this.getModel();
        if (tableModel != null) {
            ExtendedTableColumnModel cm = (ExtendedTableColumnModel)this.getColumnModel();
            cm.dropAllColumns();
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                TableColumnAdapter adapter = tableModel.getColumnAdapter(i);
                ModelPropertyTableColumn column = adapter.makeModelPropertyTableColumn(i);
                column.setHeaderRenderer(new HeaderCellRenderer(tableModel, adapter));
                this.addColumn(column);
            }
        }
    }

    @Override
    public void setModel(TableModel dm) {
        if (dm != null && !(dm instanceof IModelTableModel)) {
            throw new IllegalArgumentException("TableModel must extend IModelTableModel");
        }
        super.setModel(dm);
    }

    protected JPopupMenu createHeaderPopupMenu() {
        TableColumnModel model = this.getColumnModel();
        final JPopupMenu pm = new JPopupMenu("header-popupmenu");
        pm.add(new ColumnResetAction());
        pm.addSeparator();
        pm.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                for (int i = 0; i < pm.getComponentCount(); ++i) {
                    TableAction action;
                    Component item = pm.getComponent(i);
                    if (!(item instanceof AbstractButton) || (action = (TableAction)((AbstractButton)item).getAction()) == null) continue;
                    item.setEnabled(action.isEnabled());
                    if (!(item instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)item).setSelected(action.isSelected());
                }
            }
        });
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            TableColumn columnModel = model.getColumn(k);
            TableColumnAdapter columnAdapter = ((IModelTableModel)this.getModel()).getColumnAdapter(k);
            ColumnKeeperAction action = new ColumnKeeperAction(columnModel.getIdentifier(), columnModel.getHeaderValue());
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
            item.setSelected(true);
            pm.add(item);
        }
        return pm;
    }

    public ModelTable(Class rowClass, TableColumnAdapter[] columnAdapters) {
        this(columnAdapters);
    }

    public ModelTable(TableColumnAdapter[] columnAdapters, List initialContents) {
        this(new ModelListTableModel(columnAdapters, initialContents));
    }

    public ModelTable(Class rowClass, TableColumnAdapter[] columnAdapters, List initialContents) {
        this(new ModelListTableModel(columnAdapters, initialContents));
    }

    public ModelListTableModel getModelListTableModel() {
        return (ModelListTableModel)this.getModel();
    }

    class WrappedColumn {
        private TableColumn m_column;
        private boolean m_visible;
        private int m_initialPosition = -1;

        public WrappedColumn(TableColumn column) {
            this(column, true);
        }

        public WrappedColumn(TableColumn column, boolean visible) {
            this.m_column = column;
            this.m_visible = visible;
        }

        public TableColumn getTableColumn() {
            return this.m_column;
        }

        public void setVisible(boolean visible) {
            this.m_visible = visible;
        }

        public boolean isVisible() {
            return this.m_visible;
        }

        public int getInitialPosition() {
            return this.m_initialPosition;
        }

        public void setInitialPosition(int initialPosition) {
            if (this.m_initialPosition == -1) {
                this.m_initialPosition = initialPosition;
            }
        }
    }

    class ExtendedTableColumnModel
    extends DefaultTableColumnModel {
        private Vector m_all = new Vector();

        public void dropAllColumns() {
            while (this.getColumnCount() > 0) {
                this.removeColumn(this.getColumn(0));
            }
            this.m_all.clear();
        }

        @Override
        public void addColumn(TableColumn column) {
            int index = this.findWrappedColumn(column);
            WrappedColumn wc = index >= 0 ? (WrappedColumn)this.m_all.get(index) : null;
            boolean add = false;
            if (wc == null) {
                wc = new WrappedColumn(column);
                this.m_all.add(wc);
                wc.setInitialPosition(this.m_all.indexOf(wc));
                add = true;
            } else if (!wc.isVisible()) {
                add = true;
                wc.setVisible(true);
            }
            if (add) {
                WrappedColumn tmpWC;
                int insertIndex = 0;
                for (int i = 0; i < this.m_all.size() && (tmpWC = (WrappedColumn)this.m_all.get(i)).getTableColumn() != column; ++i) {
                    if (!tmpWC.isVisible()) continue;
                    ++insertIndex;
                }
                super.addColumn(column);
                super.moveColumn(this.getColumnCount() - 1, insertIndex);
            }
        }

        @Override
        public void removeColumn(TableColumn column) {
            WrappedColumn wc;
            int index = this.findWrappedColumn(column);
            WrappedColumn wrappedColumn = wc = index >= 0 ? (WrappedColumn)this.m_all.get(index) : null;
            if (wc != null && wc.isVisible()) {
                wc.setVisible(false);
                super.removeColumn(column);
            }
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            WrappedColumn wc;
            if (columnIndex != newIndex && (wc = (WrappedColumn)this.m_all.remove(columnIndex)) != null) {
                this.m_all.add(newIndex, wc);
            }
            super.moveColumn(columnIndex, newIndex);
        }

        public void resetToDefaults() {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                this.addColumn(wc.getTableColumn());
            }
            WrappedColumn[] tmp = this.m_all.toArray(new WrappedColumn[this.m_all.size()]);
            for (int j = 0; j < tmp.length; ++j) {
                WrappedColumn wc = tmp[j];
                int initialPosition = wc.getInitialPosition();
                int currentPosition = this.getColumnIndex(wc.getTableColumn().getIdentifier());
                if (currentPosition == initialPosition) continue;
                this.moveColumn(currentPosition, initialPosition);
            }
        }

        private int findWrappedColumn(TableColumn column) {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (wc.getTableColumn() != column) continue;
                return i;
            }
            return -1;
        }

        public boolean isColumnVisible(TableColumn column) {
            int i = this.findWrappedColumn(column);
            WrappedColumn wc = i >= 0 ? (WrappedColumn)this.m_all.get(i) : null;
            return wc != null ? wc.isVisible() : false;
        }

        public TableColumn getTableColumnExt(Object identifier) {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (wc.getTableColumn().getIdentifier() != identifier) continue;
                return wc.getTableColumn();
            }
            return null;
        }

        public boolean isDefaulted() {
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (wc.isVisible() && wc.getInitialPosition() == i) continue;
                return false;
            }
            return true;
        }

        private String debug() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.m_all.size(); ++i) {
                WrappedColumn wc = (WrappedColumn)this.m_all.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                if (!wc.isVisible()) {
                    sb.append("*");
                }
                sb.append(wc.getTableColumn().getHeaderValue());
                sb.append("(").append(wc.getInitialPosition()).append(")");
            }
            return sb.toString();
        }
    }

    class ColumnResetAction
    extends TableAction {
        public ColumnResetAction() {
            super("Reset to Defaults");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)ModelTable.this.getColumnModel();
            model.resetToDefaults();
        }

        @Override
        public boolean isEnabled() {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)ModelTable.this.getColumnModel();
            return !model.isDefaulted();
        }
    }

    class ColumnKeeperAction
    extends TableAction {
        protected Object m_identifier;

        public ColumnKeeperAction(Object identifier, Object headerValue) {
            super(headerValue.toString());
            this.m_identifier = identifier;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)evt.getSource();
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)ModelTable.this.getColumnModel();
            TableColumn column = model.getTableColumnExt(this.m_identifier);
            if (item.isSelected()) {
                model.addColumn(column);
            } else {
                model.removeColumn(column);
            }
            ModelTable.this.tableChanged(new TableModelEvent(ModelTable.this.getModel(), -1));
            ModelTable.this.repaint();
        }

        @Override
        public boolean isSelected() {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)ModelTable.this.getColumnModel();
            TableColumn column = model.getTableColumnExt(this.m_identifier);
            return model.isColumnVisible(column);
        }

        @Override
        public boolean isEnabled() {
            ExtendedTableColumnModel model = (ExtendedTableColumnModel)ModelTable.this.getColumnModel();
            TableColumn column = model.getTableColumnExt(this.m_identifier);
            return model.getColumnCount() != 1 || !model.isColumnVisible(column);
        }
    }

    class TableAction
    extends AbstractAction {
        public TableAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }

        public boolean isSelected() {
            return false;
        }
    }
}

