/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import modelobjects.util.swing.AbstractCellEditor;

public class MultilineTextCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected JTextPane textPane = new CellEditorJTextPane();
    protected JTable table;
    protected int clickCountToStart = 2;
    protected DocSizeWatcher docSizeWatcher;

    public MultilineTextCellEditor() {
        this.textPane.setEditorKit(new StyledEditorKit());
        this.docSizeWatcher = new DocSizeWatcher(this.textPane);
    }

    public JTextPane getJTextPane() {
        return this.textPane;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textPane.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.textPane.setText(value == null ? "" : (String)value);
        Document doc = this.textPane.getDocument();
        this.textPane.setDocument(doc);
        this.docSizeWatcher.setDocument(doc);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultilineTextCellEditor.this.textPane.requestFocus();
                MultilineTextCellEditor.this.textPane.repaint();
            }
        });
        return this.textPane;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int clickCount) {
        this.clickCountToStart = clickCount;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    void adjustRowHeight() {
        int preferredHeight;
        int row;
        int currentRowHeight;
        if (this.table != null && this.table.isEditing() && Math.abs((currentRowHeight = this.table.getRowHeight(row = this.table.getEditingRow())) - (preferredHeight = Math.max(this.textPane.getPreferredSize().height, this.table.getRowHeight()))) > 2) {
            this.table.setRowHeight(row, preferredHeight);
        }
    }

    protected class CellEditorJTextPane
    extends JTextPane {
        protected CellEditorJTextPane() {
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                if (!MultilineTextCellEditor.this.stopCellEditing()) {
                    MultilineTextCellEditor.this.cancelCellEditing();
                }
                MultilineTextCellEditor.this.table.dispatchEvent(e);
                e.consume();
            }
            if (!e.isConsumed()) {
                super.processKeyEvent(e);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent event) {
            if (this.isShowing()) {
                super.processMouseMotionEvent(event);
            }
        }
    }

    class FinishEditingAction
    extends AbstractAction {
        FinishEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableCellEditor editor = MultilineTextCellEditor.this.table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
        }
    }

    class DocSizeWatcher
    implements DocumentListener,
    Runnable {
        private JTextPane textPane;
        private Document doc;

        DocSizeWatcher(JTextPane textPane) {
            this.textPane = textPane;
        }

        public void setDocument(Document doc) {
            if (this.doc != null) {
                this.doc.removeDocumentListener(this);
            }
            this.doc = doc;
            if (this.doc != null) {
                this.doc.addDocumentListener(this);
            }
        }

        @Override
        public void run() {
            MultilineTextCellEditor.this.adjustRowHeight();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SwingUtilities.invokeLater(this);
        }
    }
}

