/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import modelobjects.util.swing.AbstractCellEditor;

public class NorthGravityCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private TableCellEditor innerCellEditor;
    private JPanel panel;

    public NorthGravityCellEditor(TableCellEditor innerCellEditor) {
        this.innerCellEditor = innerCellEditor;
        this.panel = new WrapperPanel();
        this.panel.setOpaque(true);
        this.panel.setLayout(new BorderLayout());
    }

    @Override
    public Object getCellEditorValue() {
        return this.innerCellEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.innerCellEditor.isCellEditable(anEvent);
    }

    @Override
    public void cancelCellEditing() {
        this.innerCellEditor.cancelCellEditing();
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        return this.innerCellEditor.stopCellEditing() && super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        final Component comp = this.innerCellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (this.panel.getComponentCount() == 0) {
            this.panel.add(comp, "North");
        } else if (this.panel.getComponent(0) != comp) {
            this.panel.remove(0);
            this.panel.add(comp, "North");
        }
        this.panel.setBackground(table.getSelectionBackground());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comp.requestFocus();
            }
        });
        return this.panel;
    }

    private static class WrapperPanel
    extends JPanel {
        private WrapperPanel() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.getComponentCount() > 0) {
                Component sub = this.getComponent(0);
                return sub.getAccessibleContext();
            }
            return super.getAccessibleContext();
        }
    }
}

