/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class PopupMenuShower
extends MouseAdapter
implements ActionListener {
    private JTree tree;
    private JTable table;
    private JPopupMenu popup;

    public PopupMenuShower(JPopupMenu popup) {
        this((JTable)null, popup);
    }

    public PopupMenuShower(JTable table, JPopupMenu popup) {
        this.table = table;
        this.popup = popup;
        Container comp = table.getParent();
        if (comp != null && comp instanceof JViewport) {
            ((JViewport)comp).addMouseListener(this);
        }
    }

    public PopupMenuShower(JTree tree, JPopupMenu popup) {
        this.tree = tree;
        this.popup = popup;
    }

    protected void showMenuIfPopupTrigger(MouseEvent event) {
        if (this.popup != null && this.popup.isPopupTrigger(event)) {
            int row;
            if (this.table != null && this.table.getSelectedRowCount() < 2) {
                int row2 = this.table.rowAtPoint(new Point(event.getX(), event.getY()));
                if (row2 >= 0) {
                    this.table.setRowSelectionInterval(row2, row2);
                }
            } else if (this.tree != null && this.tree.getSelectionCount() < 2 && (row = this.tree.getRowForLocation(event.getX(), event.getY())) >= 0) {
                this.tree.setSelectionRow(row);
            }
            if (this.popup.getComponentCount() > 0) {
                this.popup.show(event.getComponent(), event.getX(), event.getY());
                this.ensurePopupFullyOnScreen(event);
            }
        }
    }

    protected void ensurePopupFullyOnScreen(MouseEvent event) {
        Component comp = event.getComponent();
        Dimension ssz = comp.getToolkit().getScreenSize();
        Dimension psz = this.popup.getSize();
        Point loc = new Point(event.getX(), event.getY());
        SwingUtilities.convertPointToScreen(loc, comp);
        boolean mustFix = false;
        if (loc.y + psz.height > ssz.height) {
            loc.y -= psz.height;
            mustFix = true;
        }
        if (loc.x + psz.width > ssz.width) {
            loc.x -= psz.width;
            mustFix = true;
        }
        if (mustFix) {
            SwingUtilities.convertPointFromScreen(loc, comp);
            if (this.popup.getComponentCount() > 0) {
                this.popup.show(event.getComponent(), loc.x, loc.y);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.showMenuIfPopupTrigger(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.showMenuIfPopupTrigger(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Component comp = (Component)event.getSource();
        MouseEvent mouseEvent = new MouseEvent(comp, 0, 0L, 0, 0, comp.getHeight() - 1, 0, true);
        if (this.popup.getComponentCount() > 0) {
            this.popup.show(comp, mouseEvent.getX(), mouseEvent.getY());
            this.ensurePopupFullyOnScreen(mouseEvent);
        }
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.popup = menu;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public JTree getTree() {
        return this.tree;
    }

    public JTable getTable() {
        return this.table;
    }
}

